<?php

use Illuminate\Support\Facades\Route;

Route::namespace('User\Auth')->name('user.')->middleware('guest')->group(function () {
    Route::controller('LoginController')->group(function () {
        Route::get('/login', 'showLoginForm')->name('login');
        Route::post('/login', 'login');
        Route::get('logout', 'logout')->middleware('auth')->withoutMiddleware('guest')->name('logout');
    });

    Route::controller('RegisterController')->group(function () {
        Route::get('register', 'showRegistrationForm')->name('register');
        Route::post('register', 'register');
        Route::post('check-user', 'checkUser')->name('checkUser')->withoutMiddleware('guest');
    });

    Route::controller('ForgotPasswordController')->prefix('password')->name('password.')->group(function () {
        Route::get('reset', 'showLinkRequestForm')->name('request');
        Route::post('email', 'sendResetCodeEmail')->name('email');
        Route::get('code-verify', 'codeVerify')->name('code.verify');
        Route::post('verify-code', 'verifyCode')->name('verify.code');
    });

    Route::controller('ResetPasswordController')->group(function () {
        Route::post('password/reset', 'reset')->name('password.update');
        Route::get('password/reset/{token}', 'showResetForm')->name('password.reset');
    });

    Route::controller('SocialiteController')->group(function () {
        Route::get('social-login/{provider}', 'socialLogin')->name('social.login');
        Route::get('social-login/callback/{provider}', 'callback')->name('social.login.callback');
    });
});

Route::middleware('auth')->name('user.')->group(function () {
    Route::get('user-data', 'User\UserController@userData')->name('data');
    Route::post('user-data-submit', 'User\UserController@userDataSubmit')->name('data.submit');

    //authorization
    Route::middleware('registration.complete')->namespace('User')->controller('AuthorizationController')->group(function () {
        Route::get('authorization', 'authorizeForm')->name('authorization');
        Route::get('resend-verify/{type}', 'sendVerifyCode')->name('send.verify.code');
        Route::post('verify-email', 'emailVerification')->name('verify.email');
        Route::post('verify-mobile', 'mobileVerification')->name('verify.mobile');
    });

    Route::middleware(['check.status', 'registration.complete'])->group(function () {

        Route::namespace('User')->group(function () {

            Route::controller('UserController')->group(function () {
                Route::get('dashboard', 'home')->name('home');
                Route::get('download-attachments/{file_hash}', 'downloadAttachment')->name('download.attachment');

                //Report
                Route::any('payment/history', 'depositHistory')->name('deposit.history');

                Route::post('add-device-token', 'addDeviceToken')->name('add.device.token');

                Route::get('notification', 'notification')->name('notification');
                Route::get('notifications/read/{id}', 'notificationRead')->name('notification.read');
                Route::post('subscribe/plan/{id}/{interval?}', 'subscribePlan')->name('subscribe.plan');

                Route::get('referral', 'referrals')->name('referrals');
                Route::get('transactions', 'transactions')->name('transaction');
            });

            //Profile setting
            Route::controller('ProfileController')->group(function () {
                Route::get('profile-setting', 'profile')->name('profile.setting');
                Route::post('profile-setting', 'submitProfile');
                Route::get('change-password', 'changePassword')->name('change.password');
                Route::post('change-password', 'submitPassword');
            });

            Route::prefix('membership')->name('member.')->controller('MembershipController')->group(function () {
                Route::get('/', 'membership')->name('index');
                Route::get('/free-trial', 'freeTrial')->name('free.trial');
            });

            // social account
            Route::controller('SocialAccountController')->group(function () {
                Route::get('social/account', 'index')->name('social.index');
                Route::get('connect/{provider}', 'connect')->name('social.connect');
                Route::get('callback/{provider}', 'callback')->name('social.connect.callback');
                Route::post('status/connect/{id}', 'statusConnect')->name('social.status.connect');
                Route::post('connect/telegram', 'connectTelegram')->name('social.connect.telegram');
            });

            Route::controller('PostController')->prefix('post')->name('post.')->group(function () {
                Route::get('/', 'index')->name('index');
                Route::get('scheduled', 'scheduled')->name('scheduled');
                Route::get('drafted', 'drafted')->name('drafted');
                Route::get('published', 'published')->name('published');
                Route::get('create/{id?}', 'create')->name('create');
                Route::post('store/{id?}', 'store')->name('store');
                Route::post('delete/{id}', 'delete')->name('delete');
                Route::get('hashtag-generate', 'hashtagGenerate')->name('hashtag.generate');
                Route::get('content-generate', 'contentGenerate')->name('content.generate');
            });

            Route::controller('AnalyticController')->prefix('analytics')->name('analytics.')->group(function () {
                Route::get('/', 'index')->name('index');
            });

            Route::controller(('ScheduleController'))->prefix('schedule')->name('schedule.')->group(function () {
                Route::get('/', 'index')->name('index');
            });
        });

        // Payment
        Route::prefix('payment')->name('deposit.')->controller('Gateway\PaymentController')->group(function () {
            Route::get('gateway', 'deposit')->name('index');
            Route::post('insert', 'depositInsert')->name('insert');
            Route::get('confirm', 'depositConfirm')->name('confirm');
            Route::get('manual', 'manualDepositConfirm')->name('manual.confirm');
            Route::post('manual', 'manualDepositUpdate')->name('manual.update');
            Route::post('coupon', 'applyCoupon')->name('coupon.apply');
            Route::get('remove/coupon', 'removeCoupon')->name('coupon.remove');
        });
    });
});
