@extends('Template::layouts.master')
@section('content')
    <div id="calendar"></div>
@endsection

@push('script-lib')
    <script src="{{ asset(activeTemplate(true) . 'js/fullcalendar.min.js') }}"></script>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";
            let calendarEl = $('#calendar')[0];
            let events = {!! json_encode($events) !!};

            let calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: events,

                eventContent: function(arg) {
                    let wrapper = document.createElement('div');

                    let iconsDiv = document.createElement('div');
                    if (arg.event.extendedProps.platforms) {
                        arg.event.extendedProps.platforms.forEach(function(p) {
                            let img = document.createElement('img');
                            img.src = p.image;
                            img.style.width = "16px";
                            img.style.height = "16px";
                            img.style.marginRight = "4px";
                            img.style.borderRadius = "50%";
                            iconsDiv.appendChild(img);
                        });
                    }

                    let titleDiv = document.createElement('div');
                    titleDiv.textContent = arg.event.title;

                    wrapper.appendChild(iconsDiv);
                    wrapper.appendChild(titleDiv);

                    return {
                        domNodes: [wrapper]
                    };
                },

                eventClick: function(info) {
                    let eventId = info.event.id;
                    window.location.href = "post/create/" + eventId;
                },

                dayCellDidMount: function(arg) {
                    let btn = document.createElement('button');
                    btn.textContent = "+";
                    btn.classList.add('day-add-btn');

                    btn.style.display = "none";
                    btn.style.position = "absolute";
                    btn.style.top = "2px";
                    btn.style.right = "2px";
                    btn.style.padding = "2px 6px";
                    btn.style.fontSize = "12px";
                    btn.style.cursor = "pointer";

                    btn.addEventListener('click', function(e) {
                        e.stopPropagation();
                        let year = arg.date.getFullYear();
                        let month = String(arg.date.getMonth() + 1).padStart(2, '0');
                        let day = String(arg.date.getDate()).padStart(2, '0');
                        let formattedDate = `${year}-${month}-${day}`;
                        window.location.href = "post/create?date=" + formattedDate;
                    });

                    arg.el.style.position = "relative";
                    arg.el.appendChild(btn);

                    arg.el.addEventListener('mouseenter', function() {
                        btn.style.display = "block";
                    });
                    arg.el.addEventListener('mouseleave', function() {
                        btn.style.display = "none";
                    });
                }
            });

            calendar.render();
        })(jQuery);
    </script>
@endpush
