@extends('Template::layouts.master')
@section('content')
    <form class="profile-container" method="post" enctype="multipart/form-data">
        @csrf
        <div class="profile-left">
            <div class="my-profile">
                <div class="my-profile__top">
                    <div class="file-upload">
                        <label class="edit" for="profile-image"><i class="las la-camera"></i></label>
                        <input type="file" name="image" class="form-control form--control" id="profile-image"
                               hidden="">
                    </div>
                    <div class="thumb">
                        <img id="showImage" src="{{ getImage(getFilePath('userProfile') . '/' . $user->image, avatar: true) }}"
                             alt="@lang('Image')">
                    </div>
                </div>
                <div class="my-profile__content">
                    <h5 class="my-profile__mail"> {{ $user->email }} </h5>
                    <p class="my-profile__name"> {{ __($user->fullname) }} </p>
                </div>
            </div>
            <div class="contact-info-wrapper">
                <div class="contact-info">
                    <span class="contact-info__icon">
                        <i class="las la-map-marker-alt"></i>
                    </span>
                    <div class="contact-info__content">
                        <h6 class="contact-info__title"> @lang('Location') </h6>
                        <p class="contact-info__desc">{{ __($user->address) }}</p>
                    </div>
                </div>
                <div class="contact-info">
                    <span class="contact-info__icon">
                        <i class="las la-envelope"></i>
                    </span>
                    <div class="contact-info__content">
                        <h6 class="contact-info__title"> @lang('Email Address') </h6>
                        <p class="contact-info__desc"> <a href="mailto:{{ $user->email }}" class="link">
                                {{ $user->email }}
                            </a>
                        </p>
                    </div>
                </div>
                <div class="contact-info">
                    <div class="contact-info__icon">
                        <i class="las la-phone"></i>
                    </div>
                    <div class="contact-info__content">
                        <h6 class="contact-info__title"> @lang('Phone Number') </h6>
                        <p class="contact-info__desc"> <a href="telto:{{ $user->mobileNumber }}" class="link">
                                {{ $user->mobileNumber }} </a>
                        </p>
                    </div>
                </div>
                <div class="contact-info">
                    <span class="contact-info__icon">
                        <i class="las la-globe"></i>
                    </span>
                    <div class="contact-info__content">
                        <h6 class="contact-info__title"> @lang('Country') </h6>
                        <p class="contact-info__desc"> {{ __($user->country_name) }} </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="profile-right">
            <div class="row gy-4">
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="first" class="form--label"> @lang('First Name') </label>
                    <input type="text" class="form--control form-two" name="firstname"
                           value="{{ old('firstname', $user->firstname) }}" id="first">
                </div>
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="last" class="form--label"> @lang('Last Name') </label>
                    <input type="text" class="form--control form-two" name="lastname"
                           value="{{ old('lastname', $user->lastname) }}" id="last">
                </div>
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="mail" class="form--label"> @lang('Email Address') </label>
                    <input type="text" class="form--control form-two" name="email"
                           value="{{ old('email', $user->email) }}" readonly id="mail">
                </div>
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="mobile" class="form--label"> @lang('Mobile Number') </label>
                    <input type="text" class="form--control form-two" name="mobile"
                           value="{{ old('mobile', $user->mobile) }}" readonly id="mobile">
                </div>
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="dress" class="form--label"> @lang('Address') </label>
                    <input type="text" class="form--control form-two" name="address"
                           value="{{ old('address', $user->address) }}" id="dress">
                </div>
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="state" class="form--label"> @lang('State') </label>
                    <input type="text" class="form--control form-two" name="state"
                           value="{{ old('state', $user->state) }}" id="state">
                </div>
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="zip" class="form--label"> @lang('Zip Code') </label>
                    <input type="text" class="form--control form-two" name="zip"
                           value="{{ old('zip', $user->zip) }}" id="zip">
                </div>
                <div class="col-xl-6 col-lg-12 col-sm-6">
                    <label for="city" class="form--label"> @lang('City') </label>
                    <input type="text" class="form--control form-two" name="city"
                           value="{{ old('city', $user->city) }}" id="city">
                </div>
                <div class="col-sm-12">
                    <button class="btn btn--base w-100">
                        @include('Template::partials.star_svg')
                        @lang('Save Changes')
                    </button>
                </div>
            </div>
        </div>
    </form>
@endsection

@pushOnce('script')
    <script>
        (function($) {
            "use strict";
            $('#profile-image').on('change', function(e) {
                e.preventDefault();

                const files = e.target.files;

                if (files && files[0]) {
                    const reader = new FileReader();

                    reader.onload = function(event) {
                        $('#showImage').attr('src', event.target.result);
                    }

                    reader.readAsDataURL(files[0]);
                }
            });


        })
        (jQuery);
    </script>
@endPushOnce
