@extends('Template::layouts.master')
@section('content')
    <div class="post_type_wrap mb-3">
        <div class="button-group flex-align gap-3">
            <a href="{{ route('user.post.index') }}" class="btn btn--base btn-sm">@lang('All Posts')</a>
            <a href="{{ route('user.post.scheduled') }}" class="btn btn--info btn-sm">@lang('Scheduled')</a>
            <a href="{{ route('user.post.drafted') }}" class="btn btn--danger btn-sm">@lang('Drafted')</a>
            <a href="{{ route('user.post.published') }}" class="btn btn--success btn-sm">@lang('Published')</a>
        </div>
    </div>

    <div class="row gy-4">
        @forelse ($posts as $post)
            <div class="col-lg-6">
                <div class="card custom--card h-100">
                    <div class="card-header flex-between">
                        <span class="created_at"> {{ diffForHumans($post->created_at) }} </span>
                        @php
                            echo $post->statusBadge;
                        @endphp
                    </div>
                    <div class="card-body">
                        @if ($post->title != null)
                            <h6 class="draft-item__title">
                                {{ __($post->title) }}
                            </h6>
                        @endif

                        <div class="post_media flex-align gap-2 mb-3">
                            @foreach ($post->medias as $media)
                                <div class="media">
                                    @if ($media->media_type == 'image')
                                        <img class="media-image" src="{{ getImage(getFilePath('postMedia') . '/' . $media->media_path ?? '') }}" alt="@lang('img')">
                                    @else
                                        <video class="media-image" src="{{ getImage(getFilePath('postMedia') . '/' . $media->media_path ?? '') }}"></video>
                                    @endif
                                </div>
                            @endforeach
                        </div>

                        <div class="post_content">
                            <p>{{ strLimit(__($post->content), 250) }}</p>
                        </div>
                    </div>
                    <div class="card-footer p-3">
                        <div class="flex-between gap-2">
                            <div class="flex-grow-1">
                                @if ($post->schedule_start_date && $post->schedule_end_date && $post->schedule_time)
                                    <span class="schedule_date fs-14">{{ showDateTime($post->schedule_start_date, 'M d, Y') }}</span>
                                    @lang('to')
                                    <span class="schedule_date fs-14">{{ showDateTime($post->schedule_end_date, 'M d, Y') }}</span>
                                    @lang('at')
                                    <span class="schedule_time fs-14">{{ showDateTime($post->schedule_time, 'h:i A') }}</span>
                                @endif
                            </div>
                            <div class="button-group">
                                @if ($post->status != Status::PUBLISH)
                                    <a href="{{ route('user.post.create', $post->id) }}" class="btn btn--base btn--sm"><i class="las la-edit"></i></a>
                                @endif
                                <a href="javascript:void(0)" class="btn btn--danger btn--sm confirmationBtn" data-action="{{ route('user.post.delete', $post->id) }}" data-question="@lang('Are you sure to delete this post?')" class="btn btn--danger btn--sm"><i class="las la-trash"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-lg-12">
                <div class="card custom--card">
                    <div class="card-body">
                        <p class="text-center">{{ __($emptyMessage) }}</p>
                    </div>
                </div>
            </div>
        @endforelse

        <div class="pagination-wrapper">
            {{ paginateLinks($posts) }}
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('style')
    <style>
        .media-image {
            max-width: 100px;
            border-radius: 4px;
            border: 1px solid hsl(var(--black) / .1);
        }
    </style>
@endpush
