@extends('Template::layouts.master')
@section('content')
    <div class="post-container">
        <div class="post-wrapper">
            @if ($user->plan?->ai_assistant == Status::ENABLE)
                <div class="left-bar">
                    <span class="close-icon"> <i class="las la-times"></i> </span>
                    <div class="left-bar__top">
                        <span class="icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 27" fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M17.8384 12.4095L8.26075 21.9872C7.52563 22.7223 6.33306 22.7231 5.59767 21.9877L4.72851 21.1186C3.99312 20.3832 3.99397 19.1906 4.72908 18.4555L14.3068 8.87783C15.0426 8.14201 16.2352 8.14117 16.9705 8.87656L17.8397 9.74571C18.5751 10.4811 18.5742 11.6737 17.8384 12.4095ZM15.3715 12.6133L16.7069 11.2779C16.8177 11.1671 16.8171 10.9885 16.707 10.8784L15.8379 10.0092C15.7278 9.89915 15.5492 9.89853 15.4383 10.0094L14.103 11.3447L15.3715 12.6133ZM17.5146 4.97746L18.0813 4.77302C18.2474 4.71316 18.3767 4.58259 18.4359 4.41719L18.6331 3.86159C18.7461 3.54246 19.0473 3.32958 19.3851 3.32843C19.7235 3.32792 20.0254 3.53937 20.14 3.85739L20.3438 4.42417C20.4035 4.58978 20.5342 4.719 20.6998 4.77733L21.2548 4.97501C21.5736 5.08759 21.7864 5.38938 21.7873 5.72641C21.7882 6.06479 21.5766 6.36727 21.2587 6.48159L20.692 6.68603C20.5259 6.74589 20.3966 6.87647 20.3374 7.04187L20.1403 7.59746C20.0265 7.9173 19.7246 8.13089 19.3855 8.13076C19.0471 8.12993 18.7454 7.91712 18.6314 7.5984L18.4345 7.0427C18.3761 6.87703 18.2462 6.7471 18.0806 6.68742L17.5145 6.4829C17.1971 6.3689 16.9857 6.06706 16.9854 5.73066C16.9859 5.39356 17.1974 5.09242 17.5146 4.97746ZM10.8519 5.98365L11.0359 5.46429C11.1495 5.1458 11.4501 4.93228 11.7886 4.93177C12.1264 4.93062 12.4282 5.14207 12.5429 5.46009L12.7325 5.98727L13.2519 6.17193C13.5707 6.28452 13.7842 6.58559 13.7844 6.92333C13.7852 7.26171 13.5736 7.56419 13.2557 7.67852L12.7273 7.86899L12.5434 8.38835C12.4303 8.70747 12.1278 8.92042 11.7893 8.92093C11.4502 8.9208 11.1485 8.708 11.0352 8.38857L10.8506 7.8692L10.3234 7.67956C10.006 7.56556 9.79519 7.26435 9.795 6.92661C9.79544 6.58951 10.007 6.28837 10.3242 6.17341L10.8519 5.98365ZM20.4406 11.1885L20.6259 10.6691C20.739 10.35 21.0402 10.1371 21.378 10.1359C21.7164 10.1354 22.0183 10.3469 22.1329 10.6649L22.3225 11.1921L22.8419 11.3767C23.1607 11.4893 23.3735 11.7911 23.3737 12.1288C23.3752 12.4665 23.163 12.7683 22.8451 12.884L22.3174 13.0738L22.1334 13.5931C22.0197 13.913 21.7171 14.1259 21.3787 14.1264C21.0403 14.1256 20.7385 13.9128 20.6253 13.5934L20.4406 13.074L19.9134 12.8843C19.5961 12.7703 19.3846 12.4685 19.3843 12.1321C19.3848 11.795 19.5963 11.4939 19.9135 11.3789L20.4406 11.1885Z" fill="currentColor" />
                            </svg>
                        </span>
                        <h6 class="title">
                            @lang('AI Assistant')
                        </h6>
                    </div>
                    <h6 class="text">@lang(' What do you want to write about?') </h6>
                    <textarea name="prompt" class="form--control content-prompt" placeholder="@lang('Write a prompt')"></textarea>
                    <div class="left-bar__btn">
                        <button class="btn btn--base btn--sm generate-content" data-action="{{ route('user.post.content.generate') }}">
                            <span class="generate-content-text">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16" fill="none">
                                    <g clip-path="url(#clip0_16775_1663)">
                                        <path d="M9.73831 8.17443C9.73831 8.13585 9.71717 8.10022 9.68317 8.08159L6.76046 6.48313L5.162 3.56042C5.12474 3.49256 5.01327 3.49256 4.97631 3.56042L3.37785 6.48313L0.455138 8.08159C0.421282 8.10022 0.399994 8.13585 0.399994 8.17443C0.399994 8.21302 0.421135 8.24909 0.455138 8.26772L3.37785 9.86663L4.97631 12.7893C4.99494 12.8232 5.03057 12.8445 5.06915 12.8445C5.10774 12.8445 5.14337 12.8233 5.162 12.7893L6.76046 9.86663L9.68317 8.26772C9.71762 8.24894 9.73831 8.21302 9.73831 8.17443Z" fill="currentColor" />
                                        <path d="M8.24429 3.17517L9.76316 4.00573L10.5931 5.52429C10.606 5.54777 10.6307 5.56252 10.6578 5.56252C10.6849 5.56252 10.7096 5.54787 10.7225 5.52429L11.5536 4.00573L13.0718 3.17517C13.0953 3.16225 13.11 3.13755 13.11 3.1108C13.11 3.08404 13.0954 3.05934 13.0718 3.04643L11.5536 2.21615L10.7225 0.697588C10.6967 0.650027 10.6191 0.650539 10.5934 0.697588L9.76347 2.21615L8.24459 3.04643C8.22112 3.05934 8.20636 3.08404 8.20636 3.1108C8.20636 3.13755 8.22082 3.16215 8.24429 3.17517Z" fill="currentColor" />
                                        <path d="M15.5542 11.9066L13.4661 10.7647L12.3245 8.67615C12.3091 8.64804 12.2795 8.63037 12.2471 8.63037C12.2147 8.63037 12.1851 8.64792 12.1697 8.67615L11.0274 10.7647L8.93854 11.9066C8.91043 11.922 8.89276 11.9516 8.89276 11.984C8.89276 12.0164 8.91031 12.046 8.93854 12.0615L11.0274 13.2041L12.1697 15.2922C12.1851 15.3203 12.2147 15.338 12.2471 15.338C12.2795 15.338 12.3091 15.3205 12.3245 15.2922L13.4661 13.2041L15.5542 12.0615C15.5823 12.046 15.6 12.0164 15.6 11.984C15.6 11.9516 15.5823 11.922 15.5542 11.9066Z" fill="currentColor" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_16775_1663">
                                            <rect width="16" height="16" fill="currentColor" />
                                        </clipPath>
                                    </defs>
                                </svg>
                                @lang('Generate')
                            </span>
                            <span class="loader3 button-loader d-none"></span>
                        </button>
                    </div>
                </div>
            @endif
            <div class="post-wrapper__inner">
                <form id="post_form" data-action="{{ route('user.post.store', $post->id ?? '') }}" data-id="{{ $post?->id }}">
                    <div class="post-wrapper__top d-flex justify-content-between align-items-center">
                        <div class="post-list">
                            @foreach ($accounts as $key => $account)
                                <div class="form--radio form-check post-list__item ">
                                    <label class="form-check-label" for="account-{{ $account->name . '-' . $key }}">
                                        <span class="single-post">
                                            <span class="check-single">
                                                <input type="checkbox" class="account-checkbox platform-type" id="account-{{ $account->platform?->id ?? '' }}-{{ $key }}" data-platform-id="{{ $account->platform?->id ?? '' }}" data-platform-name="{{ $account->platform?->name ?? '' }}" name="selected_account[]" id="" value="{{ $account->id }}" {{ $post?->account_ids ? (in_array($account->id, $post?->account_ids) ? 'checked' : '') : '' }}>
                                                <label for="account-{{ $account->platform?->id ?? '' }}-{{ $key }}"></label>
                                            </span>
                                            <span class="single-post__thumb">
                                                <img src="{{ $account->profile_image }}" alt="">
                                                <input class="form-check-input account-switch" type="radio" name="account" id="account-{{ $account->name . '-' . $key }}" data-platform-id = "{{ $account->platform?->id ?? '' }}" data-platform-name="{{ $account->platform?->name }}" data-account="{{ $account }}" {{ $post?->account_ids ? (in_array($account->id, $post?->account_ids) ? 'disabled' : '') : '' }}>
                                            </span>
                                            <span class="single-post__icon {{ strtolower($account->platform?->name ?? '') }}">
                                                <img src="{{ getImage('assets/images/platform/' . $account->platform?->image ?? '') }}" alt="">
                                            </span>
                                        </span>
                                    </label>
                                </div>
                            @endforeach

                            @if ($user->connected_channel < $user->total_channel)
                                <a class="post-list__item add-item" href="{{ route('user.social.index') }}">
                                    <i class="las la-plus-circle"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                    <div class="post-wrapper__content">
                        <input type="text" class="form--control form-control mb-3 post-title d-none" name="title" value="{{ old('title', $post?->title) }}" placeholder="@lang('Title')">

                        <textarea name="content" class="form--control post-content emoji__area" placeholder="@lang('Write something here')..." required>{{ old('content', $post?->content) }}</textarea>

                        <span class="text--base post-hashtag {{ $post?->tags ? '' : 'd-none' }}">{{ $post?->tags ?? '' }}</span>
                        <input class="hashtag" type="hidden" name="tags" value = "{{ old('tags', $post?->tags) }}" id="tags">

                        <div class="post-tag">
                            <div class="post-tag__left">
                                <span class="tag-item hashtag_modal">
                                    #@lang('Hashtags')
                                </span>
                                @if (auth()->user()->plan?->ai_assistant == Status::ENABLE)
                                    <span class="tag-item ai-btn">
                                        @lang('AI Assist')
                                    </span>
                                @else
                                    <span class="tag-item" data-bs-toggle="modal" data-bs-target="#upgradeModal">
                                        @lang('AI Assist')
                                    </span>
                                @endif
                            </div>
                            <div class="post-tag__right">
                                <button type="button" class="post-tag__icon emoji__picker">
                                    <i class="emoji__picker fa-regular fa-face-smile"></i>
                                </button>
                            </div>
                        </div>

                        <div class="post-item media_type_warper">
                            <h5 class="post-item__title"> @lang('Media Type') </h5>
                            <small class="text-danger d-none tiktok_message">
                                @lang("TikTok requires multiple image and image dimensions between 200×200 and 4096×4096.")
                            </small>
                            <select class="form-select form--control select2 media_type" name="media_type" data-minimum-results-for-search="-1">
                                <option value="{{ Status::IMAGE }}" @selected(old('media_type', $post?->media_type) == Status::IMAGE)>@lang('Image')
                                </option>
                                <option value="{{ status::VIDEO }}" @selected(old('media_type', $post?->media_type) == status::VIDEO)>@lang('Video')
                                </option>
                            </select>
                        </div>

                        <div class="thumb-uploader-wrapper">
                            <label class="uploader-btn" for="fileInput">
                                <input type="file" name="media[]" class="post-media" id="fileInput" multiple>
                                <span class="uploader-btn__label">
                                    <span class="uploader-btn__icon">
                                        <i class="las la-plus-circle"></i>
                                    </span>
                                </span>
                            </label>
                            <div class="uploader-previews" id="previewContainer">
                                @if ($post?->medias->count() > 0)
                                    @foreach ($post?->medias as $key => $media)
                                        <div class="uploader-thumb" data-id="{{ $media->id }}">
                                            @if ($media->media_type == 'image')
                                                <img src="{{ getImage(getFilePath('postMedia') . '/' . $media->media_path) }}" alt="">
                                            @else
                                                <div class="video-thumb-wrapper">
                                                    <video class="video-thumb" src="{{ getImage(getFilePath('postMedia') . '/' . $media->media_path) }}"></video>
                                                    <div class="play-icon-overlay">
                                                        <i class="las la-play"></i>
                                                    </div>
                                                </div>
                                            @endif

                                            <span class="close-icon old-image" data-id="{{ $media->id }}">
                                                <i class="las la-times"></i>
                                            </span>
                                        </div>
                                    @endforeach

                                    <input type="hidden" class="removed_medias" name="removed_medias">
                                @endif
                            </div>
                        </div>
                        <div class="post-item who_can_see">
                            <h5 class="post-item__title"> @lang('Who users to see') </h5>
                            <select class="form-select form--control select2" name="who_can_see" data-minimum-results-for-search="-1">
                                <option value="EVERYONE" @selected(old('who_can_see', $post?->who_can_see) == 'EVERYONE')>@lang('Everyone') </option>
                                <option value="SELF" @selected(old('who_can_see', $post?->who_can_see) == 'SELF')>@lang('Only me')</option>
                                <option value="ALL_FRIENDS" @selected(old('who_can_see', $post?->who_can_see) == 'ALL_FRIENDS')>@lang('Friends')</option>
                                <option value="FRIENDS_OF_FRIENDS" @selected(old('who_can_see', $post?->who_can_see) == 'FRIENDS_OF_FRIENDS')>@lang('Friends to Friends')</option>
                            </select>
                        </div>

                        <div class="post-item who_can_see_two d-none">
                            <h5 class="post-item__title"> @lang('Audience') </h5>
                            <select class="form-select form--control select2" name="audience_type" data-minimum-results-for-search="-1">
                                <option value="{{ status::NOT_FOR_KID }}" @selected(old('audience_type', $post?->audience_type) == status::NOT_FOR_KID)>@lang('Not Made For Kids')
                                </option>
                                <option value="{{ status::FOR_KID }}" @selected(old('audience_type', $post?->audience_type) == status::FOR_KID)>@lang('Made For Kids')
                                </option>
                            </select>
                        </div>

                        <div class="post-schedule mt-4">
                            <h5 class="post-schedule__title">@lang('How would like to post this post?')</h5>
                            <div class="form-check form--radio mb-2">
                                <input class="form-check-input schedule-type" {{ $post?->post_type == Status::AUTOMATED ? 'checked' : '' }} type="radio" name="post_type" value="1" id="postType1" required>
                                <label class="form-check-label" for="postType1">
                                    @lang('Post automatically')
                                </label>
                            </div>
                            
                            <div class="form-check form--radio">
                                <input class="form-check-input schedule-type" {{ $post?->post_type == Status::REMAINDER ? 'checked' : '' }} type="radio" name="post_type" value="2" id="postType2">
                                <label class="form-check-label" for="postType2">
                                    @lang('Get a reminder')
                                </label>
                            </div>
                        </div>

                        <input type="hidden" class="first_comment" name="first_comment">
                    </div>
                    <div class="post-time-wrapper">
                        <div class="schedule">
                            <input type="text" class="form--control form-control schedule-date" name="schedule_date" placeholder="@lang('Schedule date')" value="{{ old('schedule_date', request('date') ? request('date') . ' - ' . request('date') : ($post?->schedule_start_date && $post?->schedule_end_date ? $post->schedule_start_date . ' - ' . $post->schedule_end_date : '')) }}" autocomplete="off">
                            <input type="text" class="form--control form-control schedule-time" name="schedule_time" placeholder="@lang('Time')"value="{{ old('schedule_time', $post?->schedule_time ? showDateTime($post?->schedule_time, 'H:i') : '') }}" autocomplete="off">
                        </div>
                        <div class="post-btns">
                            <button type="button" class="btn btn-outline--dark action_btn" data-submit-type ="draft" disabled> @lang('Draft') </button>
                            <button type="button" class="btn btn-outline--dark action_btn" data-submit-type ="publish" disabled> @lang('Publish') </button>
                            <button type="button" class="btn btn--base action_btn" data-submit-type ="schedule" disabled> @lang('Schedule') </button>
                        </div>
                    </div>
                    <input type="hidden" name="first_comment">
                </form>
            </div>
        </div>
        <div class="post-sidebar-wrapper">
            <div class="post-sidebar platform-preview d-none" data-preview="facebook">
                @include(activeTemplate() . 'partials.preview_facebook')
            </div>

            <div class="post-sidebar platform-preview d-none" data-preview="instagram">
                @include(activeTemplate() . 'partials.preview_instagram')
            </div>

            <div class="post-sidebar platform-preview d-none" data-preview="youtube">
                @include(activeTemplate() . 'partials.preview_youtube')
            </div>

            <div class="post-sidebar platform-preview d-none" data-preview="linkedin-openid">
                @include(activeTemplate() . 'partials.preview_linkedin')
            </div>

            <div class="post-sidebar platform-preview d-none" data-preview="telegram">
                @include(activeTemplate() . 'partials.preview_telegram')
            </div>

            <div class="post-sidebar platform-preview d-none" data-preview="twitter">
                @include(activeTemplate() . 'partials.preview_twitter')
            </div>
            
            <div class="post-sidebar platform-preview d-none" data-preview="tiktok">
                @include(activeTemplate() . 'partials.preview_tiktok')
            </div>

            <div class="post-sidebar platform-preview" data-preview="default">
                @include(activeTemplate() . 'partials.preview_default')
            </div>

        </div>

    </div>

    <div class="create-preloader d-none">
        <div class="create-preloader-icon">
            <div class="spinner-border" role="status">
            </div>
        </div>
    </div>

    <div id="leavePageModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Confirmation Alert!')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="question">@lang('Are you sure to leave this page?')</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn--sm" data-bs-dismiss="modal">@lang('No')</button>
                    <a class="btn btn--primary btn--base btn--sm leave-page-btn">@lang('Yes')</a>
                </div>
            </div>
        </div>
    </div>

    <div id="upgradeModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Upgrade Your Subscription Plan')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="question">@lang('For AI Assistant you need to upgrade your subscription plan')</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn--sm" data-bs-dismiss="modal">@lang('No')</button>
                    <a a href="{{ route('user.member.index') }}" class="btn btn--primary btn--base btn--sm">@lang('Upgrade')</a>
                </div>
            </div>
        </div>
    </div>

    <div id="hashtagModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><span class="text--base">#</span>@lang('Hashtag')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form--group">
                        <i class="fa-solid fa-wand-magic-sparkles"></i>
                        <label class="form--label">@lang('AI Suggestions')</label>
                        <div class="input-group hashtag-group">
                            <input type="text" class="form-control form--control prompt" placeholder="@lang('Short Prompt')">
                            <button class="btn btn--base generateHashtag input-group-text" type="button" data-action="{{ route('user.post.hashtag.generate') }}">
                                <i class="fa-solid fa-wand-magic-sparkles"></i>
                                <span class="loader2 button-loader d-none"></span>
                            </button>
                        </div>
                    </div>
                    <div class="row gap-3 mt-3">
                        <div class="col-lg-12 tag_input_warp">
                            <div class="form--group">
                                <label class="form--label">@lang('Hashtags')</label>
                                <textarea class="form-control form--control hashtag_input text--base" placeholder="@lang('#facebook #coffee')">{{ old('tags', $post?->tags) }}</textarea>
                            </div>
                        </div>
                        <div class="col-lg-5 generated_tags_content d-none">
                            <label class="form--label">@lang('Generated Hashtags')</label>
                            <div class="generated_tags_wrapper"></div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer button-group">
                    <a class="btn btn--primary btn--base btn--sm hashtagSubmit">@lang('Submit')</a>
                    <button type="button" class="btn btn-outline--base btn--sm add_hashtag d-none">@lang('Add Hashtags')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/global/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/daterangepicker.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/flatTimePicker.min.css') }}">
    <link rel="stylesheet" href="{{ asset(activeTemplate(true) . 'css/slick.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/daterangepicker.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/flatTimePicker.min.js') }}"></script>
    <script src="{{ asset(activeTemplate(true) . 'js/vanillaEmojiPicker.js') }}"></script>
    <script src="{{ asset(activeTemplate(true) . 'js/slick.min.js') }}"></script>
    <script src="{{ asset(activeTemplate(true) . 'js/image-preview.js') }}"></script>
    <script src="{{ asset(activeTemplate(true) . 'js/create-post.js') }}?v5"></script>
@endpush
@push('style')
    <style>
        .d-none {
            display: none !important;
        }
    </style>
@endpush
