@extends('Template::layouts.master')
@section('content')
    <div class="card custom--card">
        <div class="card-body">
            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-all" role="tabpanel" aria-labelledby="pills-all-tab" tabindex="0">
                    <div class="table-responsive">
                        <table class="table table--responsive--lg">
                            <thead>
                                <tr>
                                    <th>@lang('SL')</th>
                                    <th>@lang('Notification Title')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($notifications as $item)
                                    <tr>
                                        <td>
                                            {{ $loop->iteration }}
                                        </td>
                                        <td>
                                            {{ __($item->title) }}
                                        </td>

                                        <td class="table__sl">
                                            @php echo $item->readBadge; @endphp
                                        </td>

                                        <td>
                                            <a href="{{ route('user.notification.read', $item->id) }}" class="btn btn-outline--base btn--sm">
                                                <i class="fa-solid fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="100%" class="text-center text-dark">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="text-dark">
        {{ paginateLinks($notifications) }}
    </div>
@endsection
