@extends('Template::layouts.master')
@section('content')
    <div class="row gy-4 justify-content-center">
        <div class="col-12">
            <div class="dashboard-widget-wrapper">
                <div class="dashboard-widget flex-align">
                    <div class="dashboard-widget__icon flex-center">
                        <i class="fa-regular fa-file-lines"></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <h3 class="dashboard-widget__number">{{ $widget['total_post'] ?? 0 }}</h3>
                        <span class="dashboard-widget__text"> @lang('Total Post') </span>
                    </div>
                </div>
                <div class="dashboard-widget flex-align">
                    <div class="dashboard-widget__icon flex-center">
                        <i class="fa-solid fa-layer-group"></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <h3 class="dashboard-widget__number"> {{ $widget['connected_account'] ?? 0 }} </h3>
                        <span class="dashboard-widget__text">@lang('Connected Accounts') </span>
                    </div>
                </div>
                <div class="dashboard-widget flex-align">
                    <div class="dashboard-widget__icon flex-center">
                        <i class="fa-solid fa-clock"></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <h3 class="dashboard-widget__number">{{ $widget['scheduled_post'] ?? 0 }}</h3>
                        <span class="dashboard-widget__text"> @lang('Running Schedules')</span>
                    </div>
                </div>
                <div class="dashboard-widget flex-align">
                    <div class="dashboard-widget__icon flex-center">
                        <i class="fa-solid fa-calendar-check"></i>
                    </div>
                    <div class="dashboard-widget__content">
                        <h3 class="dashboard-widget__number"> {{ $widget['available_schedule'] ?? 0 }} </h3>
                        <span class="dashboard-widget__text"> @lang('Available Schedules') </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row gy-4 justify-content-center mt-3 flex-wrap-reverse">
        <div class="col-xxl-7 col-xl-8">
            <div class="card custom--card">
                <div class="card-header">
                    <div class="card-header__inner">
                        <h5 class="card-title">
                            @lang('Scheduled Post')
                        </h5>
                    </div>
                </div>
                <div class="card-body">
                    <div id="chart"></div>
                </div>
            </div>
            @if ($draftPosts->count() > 0)
                <div class="draft-box mt-4">
                    <h5 class="draft-box__title"> @lang('Draft Posts') </h5>
                    <div class="draft-post-wrapper">
                        @foreach ($draftPosts as $post)
                            <a href="{{ route('user.post.create', $post->id) }}">
                                <div class="draft-list">
                                    <div class="draft-item">
                                        <div class="account-wrap d-flex gap-2 flex-wrap">
                                            @foreach ($post->accounts as $account)
                                                <div class="form--radio form-check post-list__item">
                                                    <span class="single-post">
                                                        <span class="single-post__thumb">
                                                            <img src="{{ $account->profile_image }}" alt="">
                                                        </span>
                                                        <span class="single-post__icon {{ strtolower($account->platform?->name) }}">
                                                            <img src="{{ getImage('assets/images/platform/' . $account->platform?->image ?? '') }}" alt="">
                                                        </span>
                                                    </span>
                                                </div>
                                            @endforeach
                                        </div>
                                        @if ($post->title != null)
                                            <h6 class="draft-item__title">
                                                {{ __($post->title) }}
                                            </h6>
                                        @endif
                                        <p class="draft-item__desc">
                                            {{ strLimit(__($post->content), 100) }}
                                        </p>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
        <div class="col-xxl-5 col-xl-4">
            <div class="analytic-content">
                <h5 class="analytic-content__title">@lang('Post Analytics')</h5>
                <div class="analytic-list">

                    @if (isset($platformData['facebook']['hasAccounts']))
                        <div class="analytic-item facebook">
                            <div class="analytic-item__top">
                                <span class="analytic-item__icon">
                                    <i class="fa-brands fa-facebook-f"></i>
                                </span>
                                <div class="analytic-item__content">
                                    <h5 class="name"> @lang('Facebook') </h5>
                                    @if ($platformData['facebook']['hasAccounts'])
                                        <span class="analytic-item__text badge badge--success"> @lang('Connected')</span>
                                    @else
                                        <a href="{{ route('user.social.connect', 'facebook') }}" class="mt-2"><i class="fa-solid fa-plus"></i> @lang('Connect')</a>
                                    @endif
                                </div>
                            </div>

                        </div>
                    @endif

                    @if (isset($platformData['instagram']['hasAccounts']))
                        <div class="analytic-item instagram">
                            <div class="analytic-item__top">
                                <span class="analytic-item__icon">
                                    <i class="fa-brands fa-instagram"></i>
                                </span>
                                <div class="analytic-item__content">
                                    <h5 class="name"> @lang('Instagram') </h5>
                                    @if ($platformData['instagram']['hasAccounts'])
                                        <span class="analytic-item__text badge badge--success"> @lang('Connected')</span>
                                    @else
                                        <a href="{{ route('user.social.connect', 'instagram') }}" class="mt-2"><i class="fa-solid fa-plus"></i> @lang('Connect')</a>
                                    @endif
                                </div>
                            </div>


                        </div>
                    @endif

                    @if (isset($platformData['youtube']['hasAccounts']))
                        <div class="analytic-item youtube">
                            <div class="analytic-item__top">
                                <span class="analytic-item__icon">
                                    <i class="fa-brands fa-youtube"></i>
                                </span>
                                <div class="analytic-item__content">
                                    <h5 class="name"> @lang('Youtube') </h5>
                                    @if ($platformData['youtube']['hasAccounts'])
                                        <span class="analytic-item__text badge badge--success"> @lang('Connected')</span>
                                    @else
                                        <a href="{{ route('user.social.connect', 'youtube') }}" class="mt-2"><i class="fa-solid fa-plus"></i> @lang('Connect')</a>
                                    @endif
                                </div>
                            </div>


                        </div>
                    @endif

                    @if (isset($platformData['twitter']['hasAccounts']))
                        <div class="analytic-item twitter">
                            <div class="analytic-item__top">
                                <span class="analytic-item__icon">
                                    <i class="fa-brands fa-x-twitter"></i>
                                </span>
                                <div class="analytic-item__content">
                                    <h5 class="name"> @lang('Twitter') </h5>
                                    @if ($platformData['twitter']['hasAccounts'])
                                        <span class="analytic-item__text badge badge--success"> @lang('Connected')</span>
                                    @else
                                        <a href="{{ route('user.social.connect', 'twitter') }}" class="mt-2"><i class="fa-solid fa-plus"></i> @lang('Connect')</a>
                                    @endif
                                </div>
                            </div>

                        </div>
                    @endif

                    @if (isset($platformData['linkedIn']['hasAccounts']))
                        <div class="analytic-item linkedIn">
                            <div class="analytic-item__top">
                                <span class="analytic-item__icon">
                                    <i class="fa-brands fa-linkedin-in"></i>
                                </span>
                                <div class="analytic-item__content">
                                    <h5 class="name"> @lang('LinkedIn') </h5>
                                    @if ($platformData['linkedIn']['hasAccounts'])
                                        <span class="analytic-item__text > @lang('Connected')</span>
@else
<a href="{{ route('user.social.connect', 'linkedin-openid') }}" class="mt-2"><i class="fa-solid fa-plus"></i> @lang('Connect')</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif

                    @if (isset($platformData['telegram']['hasAccounts']))
                        <div class="analytic-item telegram">
                            <div class="analytic-item__top">
                                <span class="analytic-item__icon">
                                    <i class="fa-brands fa-telegram"></i>
                                </span>
                                <div class="analytic-item__content">
                                    <h5 class="name"> @lang('Telegram') </h5>
                                    @if ($platformData['telegram']['hasAccounts'])
                                        <span class="analytic-item__text badge badge--success"> @lang('Connected')</span>
                                    @else
                                        <a href="javascript:void(0)" class="mt-2" data-bs-toggle="modal" data-bs-target="#connectTelegramModal"> <i class="fa-solid fa-plus"></i>
                                            @lang('Connect') </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif

                    @if (isset($platformData['tiktok']['hasAccounts']))
                        <div class="analytic-item tiktok">
                            <div class="analytic-item__top">
                                <span class="analytic-item__icon">
                                    <i class="fa-brands fa-tiktok"></i>
                                </span>
                                <div class="analytic-item__content">
                                    <h5 class="name"> @lang('TikTok') </h5>
                                    @if ($platformData['tiktok']['hasAccounts'])
                                        <span class="analytic-item__text badge badge--success"> @lang('Connected')</span>
                                    @else
                                        <a href="{{ route('user.social.connect', 'tiktok') }}" class="mt-2"><i class="fa-solid fa-plus"></i> @lang('Connect')</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>


    @include('Template::partials.telegram_connect_modal')
@endsection

@push('breadcrumb-plugins')
    <h6 class="mb-0 fs-18"> <i class="fa-solid fa-wallet"></i> @lang('Balance : ') {{ showAmount(auth()->user()->balance) }}</h6>
@endpush

@push('script-lib')
    <script src="{{ asset(activeTemplate(true) . 'js/apexcharts.min.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            var options = {
                series: [{
                    name: 'Scheduled Posts',
                    data: {!! json_encode($postAnalytics) !!}
                }],
                chart: {
                    height: 380,
                    type: 'bar',
                },
                plotOptions: {
                    bar: {
                        borderRadius: 10,
                        columnWidth: '50%',
                        distributed: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 0
                },
                xaxis: {
                    labels: {
                        rotate: -45
                    },
                    categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                        'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
                    ],
                    tickPlacement: 'on'
                },

                fill: {
                    type: 'gradient',
                    gradient: {
                        shade: 'light',
                        type: "vertical",
                        shadeIntensity: 0.25,
                        gradientToColors: undefined,
                        inverseColors: true,
                        opacityFrom: 0.9,
                        opacityTo: 0.9,
                        stops: [50, 0, 100]
                    }
                },
                grid: {
                    borderColor: '#e7e7e7',
                    strokeDashArray: 4
                }
            };

            var chart = new ApexCharts(document.querySelector("#chart"), options);
            chart.render();
        })(jQuery);
    </script>
@endpush
