@extends('Template::layouts.master')
@section('content')
    <div class="analytic-wrapper">
        <div class="analytic-card">
            <p class="analytic-card__title"> @lang('Total Followers') </p>
            <h3 class="analytic-card__number"> {{ shortNumberFormat($widgets['followers']['totalFollowers'] ?? 0) }}
                <span class="rate bg-{{ $widgets['followers']['badge'] ?? 'success' }}"> <i
                       class="fa-solid fa-arrow-{{ isset($widgets['followers']['badge']) && $widgets['followers']['badge'] == 'success' ? 'up' : 'down' }}"></i>
                    {{ $widgets['followers']['monthlyFollowers'] ?? 0 }}% </span>
            </h3>
            <div class="analytic-card__thumb">
                <div id="followersChart"></div>
            </div>
        </div>

        <div class="analytic-card">
            <p class="analytic-card__title"> @lang('Total Likes') </p>
            <h3 class="analytic-card__number"> {{ shortNumberFormat($widgets['likes']['totalLikes'] ?? 0) }}
                <span class="rate bg-{{ $widgets['likes']['badge'] ?? 'success' }}"> <i
                       class="fa-solid fa-arrow-{{ isset($widgets['likes']['badge']) && $widgets['likes']['badge'] == 'success' ? 'up' : 'down' }}"></i>
                    {{ $widgets['likes']['monthlyLikes'] ?? 0 }}% </span>
            </h3>
            <div class="analytic-card__thumb">
                <div id="likesChart"></div>
            </div>
        </div>
        <div class="analytic-card">
            <p class="analytic-card__title"> @lang('Total Comments') </p>
            <h3 class="analytic-card__number"> {{ shortNumberFormat($widgets['comments']['totalComments'] ?? 0) }}
                <span class="rate bg-{{ $widgets['comments']['badge'] ?? 'success' }}"> <i
                       class="fa-solid fa-arrow-{{ isset($widgets['comments']['badge']) && $widgets['comments']['badge'] == 'success' ? 'up' : 'down' }}"></i>
                    {{ $widgets['comments']['monthlyComments'] ?? 0 }}% </span>
            </h3>
            <div class="analytic-card__thumb">
                <div id="commentsChart"></div>
            </div>
        </div>
        <div class="analytic-card">
            <p class="analytic-card__title"> @lang('Total Posts') </p>
            <h3 class="analytic-card__number"> {{ shortNumberFormat($widgets['posts']['totalPosts'] ?? 0) }}
                <span class="rate bg-{{ $widgets['posts']['badge'] ?? 'success' }}"> <i
                       class="fa-solid fa-arrow-{{ isset($widgets['posts']['badge']) && $widgets['posts']['badge'] == 'success' ? 'up' : 'down' }}"></i>
                    {{ $widgets['posts']['monthlyPosts'] ?? 0 }}% </span>
            </h3>
            <div class="analytic-card__thumb">
                <div id="postsChart"></div>
            </div>
        </div>
        <div class="analytic-card">
            <p class="analytic-card__title"> @lang('Total Shares') </p>
            <h3 class="analytic-card__number"> {{ shortNumberFormat($widgets['shares']['totalShares'] ?? 0) }}
                <span class="rate bg-{{ $widgets['shares']['badge'] ?? 'success' }}"> <i
                       class="fa-solid fa-arrow-{{ isset($widgets['shares']['badge']) && $widgets['shares']['badge'] == 'success' ? 'up' : 'down' }}"></i>
                    {{ $widgets['shares']['monthlyShares'] ?? 0 }}% </span>
            </h3>
            <div class="analytic-card__thumb">
                <div id="sharesChart"></div>
            </div>
        </div>
        <div class="analytic-card">
            <p class="analytic-card__title"> @lang('Engagement') </p>
            <h3 class="analytic-card__number"> {{ $widgets['engagement']['totalEngagement'] ?? 0 }}%
                <span class="rate bg-{{ $widgets['engagement']['badge'] ?? 'success' }}"> <i
                       class="fa-solid fa-arrow-{{ isset($widgets['engagement']['badge']) && $widgets['engagement']['badge'] == 'success' ? 'up' : 'down' }}"></i>
                    {{ $widgets['engagement']['monthlyEngagement'] ?? 0 }}%</span>
            </h3>
            <div class="analytic-card__thumb">
                <div id="engagementChart"></div>
            </div>
        </div>
    </div>
    @if (isset($widgets['latestPosts']))
        <div class="analytic-post">
            <h5 class="analytic-post__title"> @lang('Latest Posts') </h5>
            <div class="card custom--card">
                <div class="card-body">
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="pills-all" role="tabpanel"
                             aria-labelledby="pills-all-tab" tabindex="0">
                            <div class="table-responsive">
                                <table class="table table--responsive--lg">
                                    <thead>
                                        <tr>
                                            <th> @lang('Platform')</th>
                                            <th> @lang('Content')</th>
                                            <th> @lang('Publish Date')</th>
                                            <th> @lang('Reaction')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($widgets['latestPosts'] ?? [] as $post)
                                            <tr>
                                                <td data-label="Platform">
                                                    <div class="platform-item">
                                                        <div class="platform-item__thumb d-flex align-items-center gap-2">
                                                            <div class="content-box__thumb">
                                                                <img src="{{ $widgets['profileImage'] ?? '' }}"
                                                                     alt="">
                                                            </div>
                                                            <p class="platform-item__text">
                                                                {{ __($widgets['pageName']) ?? '' }} </p>
                                                        </div>
                                                    </div>
                                                </td>

                                                <td data-label="Content">
                                                    <a href="{{ $post['permalink'] }}" target="_blank">
                                                        <div class="content-box">
                                                            @if ($post['image'])
                                                                <div class="content-box__thumb">
                                                                    <img src="{{ $post['image'] }}" class="fit-image"
                                                                         alt="">
                                                                </div>
                                                            @endif
                                                            <p class="content-box__desc">
                                                                {{ strLimit(__($post['text']) ?? '', 70) }}
                                                            </p>
                                                        </div>
                                                    </a>
                                                </td>

                                                <td data-label="Publish Date">
                                                    {{ showDateTime($post['date'] ?? '') }}
                                                </td>

                                                <td data-label="Reaction">
                                                    <div class="icon-groups">
                                                        <span class="icon">
                                                            <i class="fa-solid fa-comment-dots"></i>
                                                            {{ shortNumberFormat($post['comments'] ?? 0) }}
                                                        </span>
                                                        <span class="icon">
                                                            <i class="fa-solid fa-thumbs-up"></i>
                                                            {{ shortNumberFormat($post['likes'] ?? 0) }}
                                                        </span>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/global/css/select2.min.css') }}">
@endpush
@push('script-lib')
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
    <script src="{{ asset(activeTemplate(true) . 'js/apexcharts.min.js') }}"></script>
@endpush


@push('breadcrumb-plugins')

    @if (!blank($socialAccounts))
        <form action="" method="GET" id ="account-form">
            <div class="analytic-filter">
                <select class="form-select form--control select2 account" name="account_id" data-minimum-results-for-search="-1">
                    @foreach ($socialAccounts as $account)
                        <option value="{{ $account->id }}" @selected(request()->account_id == $account->id)>{{ __($account->profile_name) }}
                        </option>
                    @endforeach
                </select>
            </div>
        </form>
    @endif
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.account').on('change', function() {
                $('#account-form').submit();
            });
            $('.select2').select2();
            const analyticsData = {!! json_encode($widgets) !!};

            function renderPlainBarChart(containerId, data, color) {
                let monthlyData = Object.values(data.monthlyRecord).slice(-6);

                let displayData = monthlyData.map(v => v === 0 ? 1 : v);

                let maxVal = Math.max(...monthlyData);
                if (maxVal === 0) maxVal = 10;

                var options = {
                    chart: {
                        type: 'bar',
                        height: 60,
                        sparkline: {
                            enabled: true
                        }
                    },
                    plotOptions: {
                        bar: {
                            columnWidth: '40%',
                            borderRadius: 9999,
                            borderRadiusApplication: 'around',
                        }
                    },
                    colors: [color],
                    series: [{
                        data: displayData
                    }],
                    tooltip: {
                        enabled: false
                    },
                    yaxis: {
                        min: 0,
                        max: maxVal
                    }
                };

                var chart = new ApexCharts(document.querySelector(containerId), options);
                chart.render();
            }

            renderPlainBarChart("#followersChart", analyticsData.followers, "#446DFF");
            renderPlainBarChart("#postsChart", analyticsData.posts, "#446DFF");
            renderPlainBarChart("#likesChart", analyticsData.likes, "#446DFF");
            renderPlainBarChart("#commentsChart", analyticsData.comments, "#446DFF");
            renderPlainBarChart("#sharesChart", analyticsData.shares, "#446DFF");
            renderPlainBarChart("#engagementChart", analyticsData.engagement, "#446DFF");

        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .analytic-filter {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 16px;
        }

        .analytic-filter .select2-container:has(.select2-selection--single) {
            min-width: 200px;
        }
    </style>
@endpush
