@props(['dashboard' => false])
@php
    $pricingPlanContent = getContent('pricing_plan.content', true);
    $plans = App\Models\Plan::active()->get();
@endphp


@if (!$dashboard)
    <section class="pricing-section my-120">
        <div class="container">
            <div class="section-heading">
                <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                    @include('Template::partials.star_svg')
                    {{ __($pricingPlanContent->data_values?->subheading ?? null) }}
                </span>
                <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                    {{ __($pricingPlanContent->data_values?->heading ?? null) }}
                </h2>
            </div>
@endif
<div class="row">
    <div class="col-12">
        <div class="pricing-tab">
            <div class="pricing-tab__switch">
                <label for="plan-switch">@lang('Monthly')</label>
                <div class="form-check form-switch form--switch">
                    <input class="form-check-input plan-interval" type="checkbox" role="switch" id="plan-switch">
                </div>
                <label for="plan-switch">@lang('Yearly')</label>
            </div>
            <div class="plan-trial-box">
                @if (gs('free_trial_status') == Status::ENABLE)
                    @guest
                        <svg width="208" height="92" viewBox="0 0 208 92" fill="none"
                             xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_19_8)">
                                <mask id="mask0_19_8" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0"
                                      width="208" height="92">
                                    <path
                                          d="M207.152 21.822L8.2843 0.574158L0.847558 70.178L199.716 91.4258L207.152 21.822Z"
                                          fill="white" />
                                </mask>
                                <g mask="url(#mask0_19_8)">
                                    <path
                                          d="M4.25089 57.9854C7.13468 60.3864 10.8137 61.3392 14.3816 62.2143C18.1803 63.1468 21.8999 64.3253 25.6641 65.3876C33.7878 67.6792 42.0077 69.6661 50.3538 70.9624C67.5357 73.6301 85.0348 72.7496 102.187 70.263C119.699 67.724 136.993 63.1574 153.308 56.2744C161.35 52.8811 169.193 48.9367 176.431 44.041C183.792 39.0619 190.543 33.2479 197.556 27.8067C198.119 27.3711 198.683 26.9394 199.249 26.5083C200.292 25.7129 201.716 27.1946 200.665 27.9962C193.734 33.2773 187.101 38.9414 180.02 44.0258C172.885 49.148 165.17 53.2567 157.161 56.8308C141.154 63.9754 124.111 68.7387 106.839 71.6102C89.8827 74.4293 72.3683 75.7094 55.254 73.695C47.0531 72.7302 38.9575 71.0217 30.9696 68.9527C26.8807 67.8939 22.779 66.7976 18.7601 65.4954C15.3434 64.389 11.7739 63.8501 8.3921 62.6187C6.33101 61.8677 4.44819 60.8045 2.76335 59.4016C1.74476 58.554 3.2467 57.1495 4.25089 57.9854Z"
                                          fill="#1D1D1B" />
                                    <path
                                          d="M196.556 48.2812C201.178 41.2585 202.781 33.3716 203.014 25.0732C203.255 25.413 203.497 25.7533 203.738 26.0931C195.834 24.2775 187.636 24.6349 179.588 24.2136C178.269 24.1447 178.341 22.0922 179.666 22.1614C187.901 22.5924 196.25 22.2714 204.34 24.1299C204.787 24.232 205.078 24.7145 205.065 25.1499C204.823 33.7847 203.109 42.0567 198.303 49.3609C197.576 50.4658 195.827 49.3894 196.556 48.2812Z"
                                          fill="#1D1D1B" />
                                </g>
                            </g>
                            <defs>
                                <clipPath id="clip0_19_8">
                                    <rect width="200" height="70" fill="white"
                                          transform="translate(8.2843 0.574158) rotate(6.09857)" />
                                </clipPath>
                            </defs>
                        </svg>
                        <button class="trial-text" data-wow-duration="1s" data-bs-toggle="modal"
                                data-bs-target="#loginModal">
                            {{ gs('free_trial_days') }} @lang(' Day Free Trial')
                        </button>
                    @else
                        @if (auth()->user()->free_plan_used == Status::NO)
                            <svg width="208" height="92" viewBox="0 0 208 92" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_19_8)">
                                    <mask id="mask0_19_8" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0"
                                          width="208" height="92">
                                        <path
                                              d="M207.152 21.822L8.2843 0.574158L0.847558 70.178L199.716 91.4258L207.152 21.822Z"
                                              fill="white" />
                                    </mask>
                                    <g mask="url(#mask0_19_8)">
                                        <path
                                              d="M4.25089 57.9854C7.13468 60.3864 10.8137 61.3392 14.3816 62.2143C18.1803 63.1468 21.8999 64.3253 25.6641 65.3876C33.7878 67.6792 42.0077 69.6661 50.3538 70.9624C67.5357 73.6301 85.0348 72.7496 102.187 70.263C119.699 67.724 136.993 63.1574 153.308 56.2744C161.35 52.8811 169.193 48.9367 176.431 44.041C183.792 39.0619 190.543 33.2479 197.556 27.8067C198.119 27.3711 198.683 26.9394 199.249 26.5083C200.292 25.7129 201.716 27.1946 200.665 27.9962C193.734 33.2773 187.101 38.9414 180.02 44.0258C172.885 49.148 165.17 53.2567 157.161 56.8308C141.154 63.9754 124.111 68.7387 106.839 71.6102C89.8827 74.4293 72.3683 75.7094 55.254 73.695C47.0531 72.7302 38.9575 71.0217 30.9696 68.9527C26.8807 67.8939 22.779 66.7976 18.7601 65.4954C15.3434 64.389 11.7739 63.8501 8.3921 62.6187C6.33101 61.8677 4.44819 60.8045 2.76335 59.4016C1.74476 58.554 3.2467 57.1495 4.25089 57.9854Z"
                                              fill="#1D1D1B" />
                                        <path
                                              d="M196.556 48.2812C201.178 41.2585 202.781 33.3716 203.014 25.0732C203.255 25.413 203.497 25.7533 203.738 26.0931C195.834 24.2775 187.636 24.6349 179.588 24.2136C178.269 24.1447 178.341 22.0922 179.666 22.1614C187.901 22.5924 196.25 22.2714 204.34 24.1299C204.787 24.232 205.078 24.7145 205.065 25.1499C204.823 33.7847 203.109 42.0567 198.303 49.3609C197.576 50.4658 195.827 49.3894 196.556 48.2812Z"
                                              fill="#1D1D1B" />
                                    </g>
                                </g>
                                <defs>
                                    <clipPath id="clip0_19_8">
                                        <rect width="200" height="70" fill="white"
                                              transform="translate(8.2843 0.574158) rotate(6.09857)" />
                                    </clipPath>
                                </defs>
                            </svg>
                            <button class="trial-text" data-wow-duration="1s" data-bs-toggle="modal"
                                    data-bs-target="#freePlanPurchaseModal">
                                {{ gs('free_trial_days') }} @lang(' Day Free Trial')
                            </button>
                        @endif
                    @endguest
                @endif

            </div>
        </div>
    </div>
</div>
<div class="row gy-4 justify-content-center">
    @foreach ($plans as $plan)
        @include('Template::partials.plan')
    @endforeach
</div>
@if (!$dashboard)
    </div>
    </section>
@endif

@push('script')
    <script>
        (function($) {
            "use strict";

            let monthlyPrice = $('.monthly-price');
            let yearlyPrice = $('.yearly-price');
            let monthlyCredit = $('.monthly-credit');
            let yearlyCredit = $('.yearly-credit');
            let monthlyExpired = $('.monthly-expired');
            let yearlyExpired = $('.yearly-expired');
            let monthlyTitle = $('.monthly-title');
            let yearlyTitle = $('.yearly-title');
            let monthlyPost = $('.monthly-post');
            let yearlyPost = $('.yearly-post');


            $('.plan-interval').on('change', function() {
                if ($(this).prop('checked')) {
                    monthlyPrice.addClass('d-none')
                    monthlyCredit.addClass('d-none')
                    monthlyExpired.addClass('d-none')
                    monthlyTitle.addClass('d-none')
                    monthlyPost.addClass('d-none');
                    yearlyPrice.removeClass('d-none')
                    yearlyCredit.removeClass('d-none')
                    yearlyExpired.removeClass('d-none')
                    yearlyTitle.removeClass('d-none')
                    yearlyPost.removeClass('d-none');
                } else {
                    monthlyPrice.removeClass('d-none')
                    monthlyCredit.removeClass('d-none')
                    monthlyExpired.removeClass('d-none')
                    monthlyTitle.removeClass('d-none')
                    monthlyPost.removeClass('d-none');
                    yearlyPrice.addClass('d-none')
                    yearlyCredit.addClass('d-none')
                    yearlyExpired.addClass('d-none')
                    yearlyTitle.addClass('d-none')
                    yearlyPost.addClass('d-none')
                }
            }).change();


            $('.loginBtn').on('click', function(e) {
                e.preventDefault();
                let modal = $('#loginModal');
                modal.modal('show');
            });

            $('.subscribeBtn').on('click', function(e) {
                e.preventDefault();
                let planInterval = $('.plan-interval').prop('checked') ? 1 : 0;
                let route = `{{ route('user.subscribe.plan', '') }}/${$(this).data('plan_id')}/${planInterval}`;
                let subscribeModal = $('#subscriptionModal');
                subscribeModal.find('form').attr('action', route);
                subscribeModal.modal('show');
            });
        })(jQuery)
    </script>
@endpush
