@php
    $partnerElements = getContent('partner.element', orderById: true);
    $ratingContent = getContent('rating.content', true);
    $ratingElement = getContent('rating.element', orderById: true);

@endphp
<div class="brand-secion my-120 ">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="text-center logo-testimonial">
                    <div class="logo-testimonial-content">
                        <div class="brand--title">{{ __($ratingContent?->data_values?->heading ?? '') }}</div>
                        <div class="logo-testimonial-avatar">
                            @foreach ($ratingElement as $rating)
                                <figure class="avatar-wrapper">
                                    <img src="{{ frontendImage('rating', $rating?->data_values?->image ?? '', '50x50') }}"
                                         alt="img">
                                </figure>
                            @endforeach
                        </div>
                        <div class="logo-star-wrapper">
                            @for ($i = 1; $i <= $ratingContent?->data_values?->rating ?? 5; $i++)
                                <i class="fa-solid fa-star"></i>
                            @endfor
                        </div>
                        <div class="brand--start">{{ __($ratingContent?->data_values?->title ?? '') }}</div>
                    </div>
                </div>
                <div class="brand-slider">
                    @foreach ($partnerElements ?? [] as $partnerElement)
                        <div class="company-name wow fadeInUp" data-wow-duration="1s">
                            <div class="thumb">
                                <img src="{{ frontendImage('partner', $partnerElement->data_values?->image ?? null, '145x40') }}"
                                     alt="@lang('Image')">
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
