@php
    $bannerContent = getContent('banner.content', true);
@endphp
<section class="banner-section">
    <div class="banner-section__shape">
        <img src="{{ frontendImage('banner', $bannerContent?->data_values?->background_shape ?? null, '1910x1140') }}"
             alt="@lang('image')">
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="banner-content">
                    <span class="banner-content__subtitle  wow fadeInLeft" data-wow-duration="1s">{{ __($bannerContent?->data_values?->heading ?? null) }}</span>
                    <h1 class="banner-content__title  wow fadeInLeft" data-wow-duration="1s" data-highlight-start="{{ $bannerContent?->data_values?->highline_start ?? 8 }}" data-highlight-word="{{ $bannerContent?->data_values?->highline_end ?? 9 }}">
                        {{ __($bannerContent?->data_values?->subheading ?? '') }}
                    </h1>
                    <p class="banner-content__desc  wow fadeInRight" data-wow-duration="1s">
                        {{ __($bannerContent?->data_values?->content ?? null) }}
                    </p>
                    <div class="banner-content__btn">

                        <div class="wow fadeInLeft" data-wow-duration="1s">
                            <a href="{{ url($bannerContent?->data_values?->button_url ?? '#') }}" class="btn btn--base btn--lg">
                                {{ __($bannerContent?->data_values?->button_name ?? null) }}
                            </a>
                        </div>

                        <div class="wow fadeInRight" data-wow-duration="1s">
                            <a href="{{ $bannerContent?->data_values?->youtube_link ?? '' }}" class="play-video-btn" data-fancybox>
                                <i class="fa-solid fa-circle-play me-2"></i> @lang('Watch Demo')
                            </a>
                        </div>
                    </div>
                    <div class="banner-content__thumb wow fadeInUp" data-wow-duration="2s">
                        <img src="{{ frontendImage('banner', $bannerContent?->data_values?->image ?? null, '970x530') }}" alt="@lang('image')">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.search-form__btn').on('click', function() {
                var email = $('.search-form__input').val();
                if (email == '') {
                    notify('error', 'Please enter your email address');
                    return;
                }
                var url = "{{ route('user.register', ['email' => '']) }}" + email;
                window.location.href = url;
            });
        })(jQuery);
    </script>
@endpush
