@php
    $assistantContent = getContent('assistant.content', true);
    $assistantElements = getContent('assistant.element', orderById: true);
@endphp

<div class="assistant-section my-120">
    <div class="container">
        <div class="features-contents">
            <div class="row gy-4 justify-content-between flex-wrap-reverse">
                <div class="col-lg-6 align-self-center">
                    <div class="assistant-wrapper wow fadeInUp" data-wow-duration="1s">
                        <div class="assistant-thumb">
                            <img src="{{ frontendImage('assistant', $assistantContent?->data_values?->image ?? null, '640x670') }}"
                                 alt="@lang('Image')">
                        </div>
                        <div class="assistant-wrapper__shape"></div>
                    </div>
                </div>
                <div class="col-lg-6 ps-xl-4 align-self-center">
                    <div class="section-heading style-left">
                        <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                            @include('Template::partials.star_svg')
                            {{ __($assistantContent?->data_values?->heading ?? null) }}
                        </span>
                        <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                            {{ __($assistantContent?->data_values?->subheading ?? null) }}
                        </h2>
                    </div>
                    <div class="assistant-content">
                        <p class="assistant-content__desc wow fadeInUp" data-wow-duration="1s">
                            {{ __($assistantContent?->data_values?->content ?? null) }}
                        </p>
                        <ul class="content-list">
                            @foreach ($assistantElements ?? [] as $assistantElement)
                                <li class="content-list__item wow fadeInUp" data-wow-duration="1s">
                                    <span class="content-list__icon">
                                        @php
                                            echo $assistantElement?->data_values?->icon ?? null;
                                        @endphp
                                    </span>
                                    {{ __($assistantElement?->data_values?->title ?? null) }}
                                </li>
                            @endforeach
                        </ul>
                        <div class="assistant-content__btn wow fadeInUp" data-wow-duration="1s">
                            <a href="{{ url($assistantContent?->data_values?->button_url ?? '#') }}" class="btn btn--base">
                                @include('Template::partials.star_svg')
                                {{ __($assistantContent?->data_values?->button_name ?? '') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
