@php
    $aboutContent = getContent('about.content', true);
    $aboutElements = getContent('about.element', orderById: true);
@endphp
<div class="choose-us-section my-120">
    <div class="container">
        <div class="row align-items-center gy-4 justify-content-between flex-wrap-reverse">
            <div class="col-lg-6">
                <div class="choose-us-wrapper">
                    <div class="choose-us-thumb wow fadeInUp" data-wow-duration="1s">
                        <img src="{{ frontendImage('about', $aboutContent->data_values->image ?? null, '640x625') }}"
                             alt="@lang('Image')">
                    </div>
                    <div class="choose-us-wrapper__shape"></div>
                </div>
            </div>
            <div class="col-lg-6 ">
                <div class="section-heading style-left ps-xl-5">
                    <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                        @include('Template::partials.star_svg')
                        {{ __($aboutContent->data_values->heading ?? null) }}
                    </span>
                    <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                        {{ __($aboutContent->data_values->subheading ?? null) }}
                    </h2>
                </div>
                <div class="choose-us-content ps-xl-5">
                    <ul class="content-list">
                        @foreach ($aboutElements as $about)
                            <li class="content-list__item wow fadeInUp">
                                <span class="content-list__icon"><span class="fa-solid fa-check"></span></span>
                                {{ __($about?->data_values?->heading ?? '') }}
                            </li>
                        @endforeach
                    </ul>

                    <div class="choose-us-content__btn wow fadeInUp" data-wow-duration="1s">
                        <a href="{{ $aboutContent->data_values->button_url ?? null }}" class="btn btn--base">
                            @include('Template::partials.star_svg')
                            {{ __($aboutContent->data_values->button_name ?? null) }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
