@php
    $text = isset($register) ? 'Sign Up' : 'Sign In';
@endphp

@if (gs('socialite_credentials')->linkedin->status || gs('socialite_credentials')->facebook->status == Status::ENABLE || gs('socialite_credentials')->google->status == Status::ENABLE)
    <div class="col-sm-12 wow fadeInUp" data-wow-duration="1s">
        <div class="social-login-wrapper">
            <div class="another-login">
                <span class="text"> @lang('Or') </span>
            </div>
            <ul class="social-login-list">
                @if (gs('socialite_credentials')->google->status == Status::ENABLE)
                    <li class="social-login-list__item">
                        <a href="{{ route('user.social.login', 'google') }}" class="w-100 social-login-btn google">
                            <span class="social-login-btn__icon">
                                <i class="fab fa-google"></i>
                            </span>
                            <figure class="text">
                                <span class="continue"> @lang("$text with")</span>
                                @lang('Google')
                            </figure>
                        </a>
                    </li>
                @endif
                @if (gs('socialite_credentials')->facebook->status == Status::ENABLE)
                    <li class="social-login-list__item ">
                        <a href="{{ route('user.social.login', 'facebook') }}"
                           class="w-100 social-login-btn facebook">
                            <span class="social-login-btn__icon">
                                <i class="fab fa-facebook-f"></i>
                            </span>
                            <figure class="text">
                                <span class="continue"> @lang("$text with")</span>
                                @lang('Facebook')
                            </figure>
                        </a>
                    </li>
                @endif
                @if (gs('socialite_credentials')->linkedin->status == Status::ENABLE)
                    <li class=" social-login-list__item">
                        <a href="{{ route('user.social.login', 'linkedin') }}"
                           class="w-100 social-login-btn linkedin">
                            <span class="social-login-btn__icon">
                                <i class="fab fa-linkedin-in"></i>
                            </span>
                            <figure class="text">
                                <span class="continue"> @lang("$text with")</span>
                                @lang('Linkedin')
                            </figure>
                        </a>
                    </li>
                @endif


            </ul>
        </div>
    </div>
@endif
@push('style')
    <style>
        .social-login-list__item {
            flex: 1;
        }

        .social-login-list .social-login-btn {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .social-login-list:has(.social-login-list__item:nth-child(2)) .continue {
            display: none;
        }

        .social-login-list:has(.social-login-list__item:nth-child(3)) .text {
            display: none;
        }
    </style>
@endpush
