<div id="loginModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Confirmation Alert!')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <p class="question">@lang('You have to login first to buy this plan')</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--dark btn--sm" data-bs-dismiss="modal">@lang('No')</button>
                <a href="{{ route('user.login') }}" class="btn btn--primary btn--base btn--sm">@lang('Login')</a>
            </div>
        </div>
    </div>
</div>

<div id="freePlanPurchaseModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Confirmation Alert!')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <p class="question">@lang('Are you sure to start this free plan?')</p>

                <ul class="trail-list mt-2">
                    <li class="trail-list-item">
                        <span class="title"> @lang('Validity') </span>
                        <p class="value"><span class="validity">{{ gs('free_trial_days') }}</span> @lang('Days')</p>
                    </li>
                    <li class="trail-list-item">
                        <span class="title"> @lang('Channel up to') </span>
                        <span class="channelCount value">{{ gs('channel_count') }}</span>
                    </li>
                    <li class="trail-list-item">
                        <span class="title"> @lang('Schedule up to') </span>
                        <span class="postCount value">{{ gs('schedule_count') }}</span>
                    </li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--dark btn--sm" data-bs-dismiss="modal">@lang('No')</button>
                <a href="{{ route('user.member.free.trial') }}" class="btn btn--primary btn--base btn--sm">@lang('Yes')</a>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="subscriptionModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title">@lang('Confirm Subscription!')</h6>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <form method="POST">
                @csrf
                <div class="modal-body">
                    <h6 class="text-center mb-0">@lang('Are you sure to subscribe this plan?')</h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--danger btn--md" data-bs-dismiss="modal">@lang('No')</button>
                    <button type="submit" class="btn btn--base btn--md">@lang('Yes')</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('style')
    <style>
        .trail-list-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 12px;
        }

        .trail-list-item:not(:last-child) {
            margin-bottom: 8px;
            padding-bottom: 8px;
            border-bottom: 1px solid hsl(var(--black) / .1);
        }

        .trail-list-item .title {
            color: hsl(var(--black) / .6);
        }

        .trail-list-item .value {
            font-weight: 500;
            color: hsl(var(--black));
        }
    </style>
@endpush
