@php
    $languages = App\Models\Language::get();
    $defaultLanguage = $languages->where('code', app()->getLocale())->first();
@endphp
<div class="custom--dropdown">
    <div class="custom--dropdown__selected dropdown-list__item">
        <div class="thumb">
            <img src="{{ getImage(getFilePath('language') . '/' . $defaultLanguage->image, getFileSize('language')) }}" alt="@lang('image')">
        </div>
        <span class="text"> {{ __($defaultLanguage->code) }} </span>
    </div>
    <ul class="dropdown-list">
        @foreach ($languages as $language)
            <li class="dropdown-list__item">
                <a href="{{ route('lang', $language->code) }}" class="thumb">
                    <img src="{{ getImage(getFilePath('language') . '/' . $language->image, getFileSize('language')) }}" alt="@lang('image')">
                    <span class="text"> {{ __($language->code) }} </span>
                </a>
            </li>
        @endforeach
    </ul>
</div>
