@php
    $pages = \App\Models\Page::where('is_default', Status::NO)->where('tempname', activeTemplate())->orderBy('id', 'DESC')->get();
@endphp
<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-xl navbar-light">
            <a class="navbar-brand logo" href="{{ route('home') }}">
                <img src="{{ siteLogo() }}" alt="@lang('image')">
            </a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasDarkNavbar" aria-controls="offcanvasDarkNavbar" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="offcanvas border-0 offcanvas-end" tabindex="-1" id="offcanvasDarkNavbar">
                <div class="offcanvas-header">
                    <a class="logo navbar-brand" href="{{ route('home') }}">
                        <img src="{{ siteLogo() }}" alt="@lang('image')">
                    </a>
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="offcanvas-body">
                    <ul class="navbar-nav nav-menu align-items-xl-center justify-content-center w-100">
                        <li class="nav-item d-xl-none">
                            <div class="d-flex align-items-center justify-content-between gap-2">
                                @guest
                                    <a href="{{ route('user.login') }}" class="btn btn--md  btn-outline--white">
                                        <span class="icon">
                                            <i class="fa-regular fa-circle-user"></i>
                                        </span>
                                        @lang('Login')
                                    </a>
                                @else
                                    <a href="{{ route('user.home') }}" class="btn btn--md  btn-outline--white">
                                        <span class="icon">
                                            <i class="fa-regular fa-circle-user"></i>
                                        </span>
                                        @lang('Dashboard')
                                    </a>
                                @endguest

                                @include('Template::partials.language')
                            </div>
                        </li>
                        <li class="nav-item {{ menuActive('home') }}">
                            <a class="nav-link" aria-current="page" href="{{ route('home') }}">@lang('Home')</a>
                        </li>
                        @foreach ($pages as $page)
                            <li class="nav-item if @if ($page->slug == Request::segment(1)) active @endif">
                                <a class="nav-link" href="{{ route('pages', [$page->slug]) }}">{{ __($page->name) }}</a>
                            </li>
                        @endforeach
                        <li class="nav-item {{ menuActive('plans') }}">
                            <a class="nav-link" href="{{ route('plans') }}">@lang('Plan')</a>
                        </li>

                        <li class="nav-item {{ menuActive('blog*') }}">
                            <a class="nav-link" href="{{ route('blog') }}">@lang('Blog')</a>
                        </li>
                        <li class="nav-item {{ menuActive('contact') }}">
                            <a class="nav-link" href="{{ route('contact') }}">@lang('Contact')</a>
                        </li>

                    </ul>
                </div>
            </div>
            <div class="header-right d-none d-xl-flex">
                @include('Template::partials.language')
                @guest
                    <a href="{{ route('user.login') }}" class="btn btn--md  btn--base">
                        <span class="icon">
                            <i class="fa-regular fa-circle-user"></i>
                        </span>
                        @lang('Login')
                    </a>
                @else
                    <a href="{{ route('user.home') }}" class="btn btn--md  btn-outline--white">
                        <span class="icon">
                            <i class="fa-regular fa-circle-user"></i>
                        </span>
                        @lang('Dashboard')
                    </a>
                @endguest
            </div>
        </nav>
    </div>
</header>

@include('Template::partials.plan_purchase_modal')
