@php
    $user = auth()->user();
    $userNotificationCount = \App\Models\UserNotification::where('user_id', auth()->id())
        ->where('is_read', Status::NO)
        ->orderBy('id', 'desc')
        ->take(10)
        ->count();
@endphp
<div class="dashboard-header">
    <div class="dashboard-header__inner flex-between">
        <div class="dashboard-header__left">
            <div class="dashboard-body__bar d-lg-none d-block">
                <span class="dashboard-body__bar-icon"><i class="fas fa-bars"></i></span>
            </div>
            <div class="left-content">
                <h5 class="dashboard-header__title mb-0"> {{ $user->fullname }} </h5>
                <p class="dashboard-header__desc">
                    @lang('Today is') {{ date('l') }}, {{ date('d M Y') }}
                </p>
            </div>
        </div>
        <div class="dashboard-header__right flex-align">
            @if (!$user->plan_id || ($user->expired_at && $user->expired_at->lt(now()->addDays(7))))
                <a href="{{ route('user.member.index') }}" class="btn btn--base btn--sm"> @lang('UPGRADE PLAN')</a>
            @endif

            <div class="header__widgets__notifications">
                <a class="notification-link" href="{{ route('user.notification') }}">
                    <i class="fa-regular fa-bell"></i>
                </a>
                @if ($userNotificationCount > 0)
                    <span class="notification-count">{{ $userNotificationCount <= 9 ? $userNotificationCount : '9+' }}</span>
                @endif

            </div>
            <div class="user-info">
                <button class="user-info__button flex-align">
                    <span class="user-info__thumb">
                        <img src="{{ getImage(getFilePath('userProfile') . $user->image, avatar: true) }}" class="fit-image" alt="@lang('image')">
                    </span>
                </button>
                <ul class="user-info-dropdown">
                    <li class="user-info-dropdown__item">
                        <a class="user-info-dropdown__link" href="{{ route('user.profile.setting') }}">
                            <span class="icon"><i class="las la-cog"></i></span>
                            <span class="text">
                                @lang('Profile Setting')
                            </span>
                        </a>
                    </li>
                    <li class="user-info-dropdown__item"><a class="user-info-dropdown__link" href="{{ route('user.change.password') }}">
                            <span class="icon"><i class="las la-key"></i></span>
                            <span class="text">@lang('Change Password')</span>
                        </a>
                    </li>
                    <li class="user-info-dropdown__item"><a class="user-info-dropdown__link" href="{{ route('ticket.index') }}">
                            <span class="icon">
                                <i class="las la-headset"></i>
                            </span>
                            <span class="text"> @lang('Support Ticket') </span>
                        </a>
                    </li>
                    <li class="user-info-dropdown__item"><a class="user-info-dropdown__link logout" href="{{ route('user.logout') }}">
                            <span class="icon">
                                <i class="las la-sign-out-alt"></i>
                            </span>
                            <span class="text">@lang('Logout')</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
