@extends('Template::layouts.app')
@section('main')
    <section class="account">
        <div class="account__shape">
            <img src="{{ frontendImage($dataKey, $authContent->data_values->background_shape ?? null, '1920x1145') }}"
                 alt="@lang('Image')">
        </div>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-6 col-lg-7 col-sm-12">
                    <div class="account-form-wrapper">
                        <div class="account-form">
                            <div class="account-form__content">
                                <a href="{{ route('home') }}" class="account-logo wow fadeInUp" data-wow-duration="1s">
                                    <img src="{{ siteLogo('dark') }}" alt="@lang('image')">
                                </a>
                                <span class="account-form__subtitle wow fadeInUp" data-wow-duration="1s">
                                    @include('Template::partials.star_svg')
                                    {{ __($authContent->data_values->heading ?? null) }}
                                    @include('Template::partials.star_svg')
                                </span>
                                <h4 class="account-form__title wow fadeInUp" data-wow-duration="1s">
                                    {{ __($authContent->data_values->subheading ?? null) }} </h4>
                            </div>

                            @yield('content')

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
