@extends('Template::layouts.frontend')
@section('content')
    @php
        $contactContent = getContent('contact_us.content', true);
    @endphp

    <div class="contact-section my-120">
        <div class="container">
            <div class="contact-top">
                <div class="row gy-4 justify-content-between">
                    <div class="col-lg-12">
                        <div class="section-heading style-left">
                            <span class="section-heading__subtitle wow fadeInUp" data-wow-duration="1s">
                                @include('Template::partials.star_svg')
                                {{ __($contactContent?->data_values?->heading ?? null) }}
                            </span>
                            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="1s">
                                {{ __($contactContent?->data_values?->subheading ?? null) }}
                            </h2>
                        </div>
                        <div class="row gy-4">
                            <div class="col-sm-6 col-lg-4 contact-col wow fadeInUp" data-wow-duration="1s">
                                <div class="contact-widget">
                                    <span class="icon">
                                        <i class="fa-solid fa-map-location-dot"></i>
                                    </span>
                                    <div class="content">
                                        <h5 class="title mb-2">@lang('Contact Address')</h5>
                                        <div class="contact-info">
                                            <p class="contact-info__item">
                                                {{ __($contactContent?->data_values?->contact_details ?? null) }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class=" col-sm-6 col-lg-4 contact-col wow fadeInUp" data-wow-duration="1s">
                                <div class="contact-widget">
                                    <span class="icon">
                                        <i class="fa-solid fa-phone-volume"></i>
                                    </span>
                                    <div class="content">
                                        <h5 class="title mb-2">@lang('Contact Number')</h5>
                                        <div class="contact-info">
                                            <a href="tel:{{ $contactContent->data_values->contact_number ?? null }}" class="contact-item__desc">{{ __($contactContent?->data_values?->contact_number ?? null) }} </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-4 contact-col wow fadeInUp" data-wow-duration="1s">
                                <div class="contact-widget">
                                    <span class="icon">
                                        <i class="las la-envelope-open-text"></i>
                                    </span>
                                    <div class="content">
                                        <h5 class="title mb-2">@lang('Email Address')</h5>
                                        <div class="contact-info">
                                            <a href="mailto:{{ $contactContent?->data_values?->email_address ?? null }}" class="contact-item__desc">{{ __($contactContent?->data_values?->email_address ?? null) }} </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="contact-bottom my-120">
        <div class="container">
            <div class="contact-bottom__content">
                <div class="row gx-0 gy-4 flex-wrap-reverse">
                    <div class="col-lg-6 ps-lg-5 d-none d-lg-block align-self-center">
                        <div class="contact-wrapper">
                            <div class="contact-thumb  wow fadeInUp" data-wow-duration="1s">
                                <img src="{{ frontendImage('contact_us', $contactContent->data_values->image_one ?? null, '650x670') }}"
                                     alt="@lang('Image')">
                            </div>
                            <div class="contact-wrapper__shape"></div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="contact-form">
                            <div class="contact-heading">
                                <h2 class="contact-form__title  wow fadeInUp" data-wow-duration="1s">
                                    {{ __($contactContent->data_values->form_heading ?? null) }}</h2>
                                <p>{{ __($contactContent->data_values->description ?? null) }}</p>
                            </div>
                            <form method="post" class="verify-gcaptcha">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-12  wow fadeInUp" data-wow-duration="1s">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Name') </label>
                                            <input name="name" type="text" class="form--control" value="{{ old('name', $user?->fullname) }}"
                                                   @if ($user && $user->profile_complete) readonly @endif required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12  wow fadeInUp" data-wow-duration="1s">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Email')</label>
                                            <input name="email" type="email" class="form--control" value="{{ old('email', $user?->email) }}"
                                                   @if ($user) readonly @endif required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12  wow fadeInUp" data-wow-duration="1s">
                                        <div class="form-group">
                                            <label class="form--label">@lang('Subject')</label>
                                            <input name="subject" type="text" class="form--control" value="{{ old('subject') }}"
                                                   required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12  wow fadeInUp" data-wow-duration="1s">
                                        <div class="form-group">
                                            <label for="mes" class="form--label">@lang('Message')</label>
                                            <textarea name="message" class="form--control" required>{{ old('message') }}</textarea>
                                        </div>
                                    </div>

                                    <x-captcha />
                                </div>

                                <div class="wow fadeInUp" data-wow-duration="1s">
                                    <button type="submit" class="btn btn--base w-100 btn--lg">@lang('Submit')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (isset($sections->secs) && $sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include('Template::sections.' . $sec)
        @endforeach
    @endif
@endsection


@push('style')
    <style>
        .form--control {
            background: hsl(var(--white));
        }
    </style>
@endpush
