@extends('Template::layouts.frontend')
@section('content')
    <section class="blog-detials py-120">
        <div class="container">
            <div class="row gy-5 justify-content-center">
                <div class="col-xl-9 col-lg-8">
                    <div class="blog-details me-xl-4">
                        <div class="blog-details__thumb wow fadeInUp" data-wow-duration="1s">
                            <img src="{{ frontendImage('blog', $blog?->data_values?->image, '1260x915') }}" class="w-100"
                                 alt="@lang('Blog')">
                        </div>
                        <div class="blog-details__content">
                            <span class="blog-item__date wow fadeInUp" data-wow-duration="1s">
                                <i class="fa-solid fa-clock text--base"></i> {{ showDateTime($blog->created_at, 'd M, Y') }}
                            </span>
                            <div class="content-item">
                                <h3 class="blog-details__title wow fadeInUp" data-wow-duration="1s">
                                    {{ __($blog->data_values->title ?? null) }}
                                </h3>
                            </div>

                            <div class="wow fadeInUp">
                                @php echo $blog->data_values->description; @endphp
                            </div>
                            <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                            <div class="blog-details__content-bottom">
                                <div class="blog-details__share d-flex align-items-center flex-wrap">
                                    <h5 class="social-share__title mb-0 me-sm-3 me-1 d-inline-block">Share:</h5>
                                    <ul class="blog-social list-two">
                                        <li class="blog-social__item">
                                            <a class="blog-social__link flex-center" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}">
                                                <i class="fab fa-facebook-f"></i>
                                            </a>
                                        </li>
                                        <li class="blog-social__item">
                                            <a class="blog-social__link flex-center" target="_blank" href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($blog->title) }}">
                                                <i class="fa-brands fa-x-twitter"></i>
                                            </a>
                                        </li>
                                        <li class="blog-social__item">
                                            <a class="blog-social__link flex-center" target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode(url()->current()) }}&title={{ urlencode($blog->title) }}">
                                                <i class="fab fa-linkedin-in"></i>
                                            </a>
                                        </li>
                                        <li class="blog-social__item">
                                            <a class="blog-social__link flex-center" target="_blank" href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(frontendImage('blog', 'thumb_' . $blog?->data_values?->image, '730x670')) }}&description={{ urlencode($blog?->data_values?->title ?? '') }}">
                                                <i class="fab fa-pinterest"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                </div>
                <div class="col-xl-3 col-lg-4">
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar wow fadeInUp" data-wow-duration="1s">
                            <div class="blog-sidebar__top">
                                <h5 class="blog-sidebar__title"> @lang('Latest Blog') </h5>
                            </div>
                            <div class="blog-sidebar__content">
                                @foreach ($latestBlogs as $latestBlog)
                                    <div class="latest-blog">
                                        <div class="latest-blog__thumb">
                                            <a href="{{ route('blog.details', $latestBlog->slug) }}">
                                                <img class="image1"
                                                     src="{{ frontendImage('blog', 'thumb_' . ($latestBlog?->data_values?->image ?? null), '420x305') }}"
                                                     alt="@lang('image')">
                                            </a>
                                        </div>
                                        <div class="latest-blog__content">
                                            <h6 class="latest-blog__title">
                                                <a href="{{ route('blog.details', $latestBlog->slug) }}">
                                                    {{ __($latestBlog?->data_values?->title ?? null) }}
                                                </a>
                                            </h6>
                                            <span class="latest-blog__date fs-12">
                                                {{ showDateTime($latestBlog->created_at, 'd M, Y') }} </span>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush

@push('style')
    <style>
        main {
            overflow: unset;
        }
    </style>
@endpush
