@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-md-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two custom-data-table table">
                            <thead>
                                <tr>
                                    <th>@lang('Title')</th>
                                    <th>@lang('Client ID')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (gs('social_connect_credential') ?? [] as $key => $credential)
                                    <tr>
                                        <td class="fw-bold">
                                            {{ ucfirst($key) }}
                                        </td>
                                        <td>{{ $credential->client_id }}</td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-outline--primary btn-sm editBtn" data-client_id="{{ $credential->client_id }}" data-client_secret="{{ $credential->client_secret }}" data-api_key="{{ $credential?->api_key ?? '' }}" data-key="{{ $key }}"><i class="la la-cogs"></i>@lang('Configure')</button>
                                                <a href="{{ route('admin.platform.setting.help', $key) }}" class="btn btn-sm btn-outline--dark helpBtn" data-type="{{ $key }}" type="button">
                                                    <i class="la la-question"></i>@lang('Help')</a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Update Credential'): <span class="credential-name"></span></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" action="">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Client ID')</label>
                            <input class="form-control" name="client_id" type="text">
                        </div>
                        <div class="form-group">
                            <label>@lang('Client Secret')</label>
                            <input class="form-control" name="client_secret" type="text">
                        </div>
                        <div class="form-group youtube-api-key d-none">
                            <label>@lang('API Key')</label>
                            <input class="form-control" name="api_key" type="text">
                        </div>
                        <div class="form-group">
                            <label>@lang('Callback URL')</label>
                            <div class="input-group">
                                <input class="form-control callback" type="text" readonly>
                                <button class="input-group-text copyInput" type="button" title="@lang('Copy')">
                                    <i class="las la-clipboard"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" id="editBtn" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="helpModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Update Credential'): <span class="credential-name"></span></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="description p-3"></div>
                </div>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";
            $(document).on('click', '.editBtn', function() {
                let modal = $('#editModal');
                let data = $(this).data();
                let route = "{{ route('admin.platform.update', '') }}";
                let callbackUrl = "{{ route('user.social.connect.callback', '') }}";
                modal.find('form').attr('action', `${route}/${data.key}`);
                modal.find('.credential-name').text(data.key);

                modal.find('[name=client_id]').prop('readonly', false);
                modal.find('[name=client_secret]').prop('readonly', false);

                if (data.key == 'youtube') {
                    modal.find('.youtube-api-key').removeClass('d-none');
                    modal.find('[name=api_key]').val(data.api_key);
                } else if (data.key == 'telegram' || data.key == 'instagram') {
                    modal.find('[name=client_id]').val('NOT REQUIRED').prop('readonly', true);
                    modal.find('[name=client_secret]').val('NOT REQUIRED').prop('readonly', true);
                } else {
                    modal.find('.youtube-api-key').addClass('d-none');
                }
                modal.find('[name=client_id]').val(data.client_id);
                modal.find('[name=client_secret]').val(data.client_secret);
                modal.find('.callback').val(`${callbackUrl}/${data.key}`);
                modal.modal('show');
            });

            $('.copyInput').on('click', function(e) {
                var copybtn = $(this);
                var input = copybtn.closest('.input-group').find('input');
                if (input && input.select) {
                    input.select();
                    try {
                        document.execCommand('SelectAll')
                        document.execCommand('Copy', false, null);
                        input.blur();
                        notify('success', `Copied: ${copybtn.closest('.input-group').find('input').val()}`);
                    } catch (err) {
                        alert('Please press Ctrl/Cmd + C to copy');
                    }
                }
            });
        })(jQuery);
    </script>
@endpush
