@extends('admin.layouts.app')

@section('panel')
    <div class="doc-container">
        <div class="row gy-4">
            <div class="col-xl-3">
                <div class="doc-sidebar">
                    <h5>@lang('Table of Contents')</h5>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#overview">@lang('Overview')</a>
                        <a class="nav-link" href="#prerequisites">@lang('Prerequisites')</a>
                        <a class="nav-link" href="#create-channel">@lang('Create Telegram Channel')</a>
                        <a class="nav-link" href="#create-bot">@lang('Create Telegram Bot')</a>
                        <a class="nav-link" href="#connect-bot">@lang('Connect Bot to Channel')</a>
                        <a class="nav-link" href="#get-credentials">@lang('Get Credentials')</a>
                        <a class="nav-link" href="#setup-app">@lang('Setup Application')</a>
                        <a class="nav-link" href="#troubleshooting">@lang('Troubleshooting')</a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-xl-9">
                <div class="doc-content">

                    <section id="overview" class="doc-section">
                        <h2>@lang('Overview')</h2>
                        <p>@lang('This documentation will guide you through creating a Telegram Bot to post content to your Telegram Channel. You\'ll learn how to create a channel, create a bot using BotFather, connect the bot to your channel, and obtain credentials.')</p>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Important:')</strong> @lang('Telegram Bot integration requires a Telegram account, a channel, and a bot with administrator privileges.')
                        </div>
                    </section>

                    <section id="prerequisites" class="doc-section">
                        <h2>@lang('Prerequisites')</h2>
                        <p>@lang('Ensure the following requirements are met:')</p>
                        <div class="requirements-list">
                            <ul>
                                <li><strong>@lang('Telegram Account')</strong><br>@lang('A valid Telegram account with an active phone number.')</li>
                                <li><strong>@lang('Telegram Application')</strong><br>@lang('Telegram app installed on your device.')</li>
                                <li><strong>@lang('Access to BotFather')</strong><br>@lang('Access to @BotFather for creating bots.')</li>
                                <li><strong>@lang('Administrator Rights')</strong><br>@lang('Ability to add bots to your channel.')</li>
                            </ul>
                        </div>
                    </section>

                    <section id="create-channel" class="doc-section">
                        <h2>@lang('Step 1: Create a Telegram Channel')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Open Telegram & Create Channel')</div>
                                    <p>@lang('Open Telegram, click Menu icon and select') <strong>@lang('"New Channel"')</strong>.</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/telegram/01.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/01.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Setup Channel Details')</div>
                                    <p>@lang('Enter Channel Name, Description (optional), and Photo (optional). Click Create.')</p>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/02.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/02.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/03.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/03.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Set Channel Type')</div>
                                    <p>@lang('Choose Public (accessible via link) or Private (invite only). Click Save.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/telegram/04.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/04.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom">
                            <strong><i class="fas fa-check-circle me-2"></i>@lang('Success!')</strong>
                            @lang('Your Telegram Channel has been created successfully.')
                        </div>
                    </section>

                    <section id="create-bot" class="doc-section">
                        <h2>@lang('Step 2: Create a Telegram Bot')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Search for BotFather')</div>
                                    <p>@lang('Search for') <strong>@lang('"@BotFather"')</strong> @lang('and start conversation. Send') <strong>@lang('/newbot')</strong> @lang('command.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/telegram/05.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/05.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Configure Bot')</div>
                                    <p>@lang('Enter Bot Name and Bot Username (must end with "bot"). BotFather will create your bot.')</p>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/06.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/06.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/07.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/07.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">3</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Save Bot Token')</div>
                                    <p>@lang('BotFather provides a') <strong>@lang('Bot Token')</strong>. @lang('Copy and save it securely.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/telegram/07.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/07.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Note:')</strong> @lang('Keep your bot token confidential.')
                        </div>
                    </section>

                    <section id="get-credentials" class="doc-section">
                        <h2>@lang('Step 4: Get Bot Token & Channel ID')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Bot Token')</div>
                                    <p>@lang('You received the Bot Token from BotFather in Step 2. To retrieve it again: send') <strong>@lang('/mybots')</strong> @lang('to BotFather, select your bot, click "API Token".')</p>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/12.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/12.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/13.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/13.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/14.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/14.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Get Channel ID')</div>
                                    <p><strong>@lang('Method 1: Web Telegram')</strong></p>
                                    <ul class="app-details-list">
                                        <li>@lang('Open') <a href="https://web.telegram.org" target="_blank">web.telegram.org</a></li>
                                        <li>@lang('Go to your channel, check URL: https://web.telegram.org/k/#-1001234567890')</li>
                                        <li>@lang('Channel ID is the number after "#":') <code>-1001234567890</code></li>
                                    </ul>

                                    <p><strong>@lang('Method 2: @getidsbot') (@lang('Recommended'))</strong></p>
                                    <ul class="app-details-list">
                                        <li>@lang('Search') <strong>@lang('@userinfobot')</strong> @lang('in Telegram')</li>
                                        <li>@lang('Forward a message from your channel to the bot')</li>
                                        <li>@lang('Bot will reply with Channel ID')</li>
                                    </ul>

                                    <p><strong>@lang('Method 3: API Request')</strong></p>
                                    <ul class="app-details-list">
                                        <li>@lang('Post a message in your channel')</li>
                                        <li>@lang('Visit:') <code>https://api.telegram.org/bot{YOUR_BOT_TOKEN}/getUpdates</code></li>
                                        <li>@lang('Find "chat":{"id": in response')</li>
                                    </ul>

                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/16.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/16.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/17.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/17.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/18.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/18.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Channel IDs start with -100. Include the minus sign.')
                        </div>
                    </section>

                    <section id="setup-app" class="doc-section">
                        <h2>@lang('Step 5: Setup in Application')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start step-card__wrapper">
                                <span class="step-number">1</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Configure Application')</div>
                                    <p>@lang('Go to your application user panel, navigate to Telegram settings.')</p>
                                    <p>@lang('Enter Bot Token and Channel ID.')</p>
                                    <p>@lang('Click Save.')</p>
                                    <div class="screenshots-container">
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/19.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/19.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>
                                        <div class="screenshot-wrapper">
                                            <a href="{{ asset('assets/admin/images/documentation/telegram/20.png') }}" class="image-link">
                                                <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/telegram/20.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom">
                            <strong><i class="fas fa-check-circle me-2"></i>@lang('Success!')</strong>
                            @lang('Telegram Bot is configured and ready.')
                        </div>
                    </section>

                    <section id="troubleshooting" class="doc-section">
                        <h2>@lang('Troubleshooting')</h2>
                        <h3>@lang('Common Issues and Solutions')</h3>

                        <div class="step-card">
                            <div class="step-title">@lang('Bot Cannot Post to Channel')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Bot lacks permissions')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Verify bot is admin with "Post Messages" enabled. Check Channel ID includes minus sign.')</p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Invalid Bot Token')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Unauthorized error')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Verify token is correct, no spaces. Get new token from BotFather if needed.')</p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Wrong Channel ID')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Chat not found')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Ensure Channel ID is correct with minus sign. Use getidsbot or web.telegram.org to verify.')</p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Message Not Appearing')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('No error but message not posted')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Check if bot is still admin. Verify channel exists. Test with simple text message first.')</p>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Never share your bot token publicly. Anyone with the token can control your bot.')
                        </div>

                        <h3>@lang('Useful Resources')</h3>
                        <div class="requirements-list">
                            <ul class="app-details-list">
                                <li><a href="https://core.telegram.org/bots" target="_blank">@lang('Telegram Bot API Documentation')</a></li>
                                <li><a href="https://core.telegram.org/bots/api" target="_blank">@lang('Bot API Methods')</a></li>
                                <li><a href="https://core.telegram.org/bots/faq" target="_blank">@lang('Bot FAQ')</a></li>
                                <li><a href="https://telegram.org/support" target="_blank">@lang('Telegram Support')</a></li>
                            </ul>
                        </div>
                    </section>

                    <div class="text-center mt-5 pt-4 border-top">
                        <p class="text-muted">@lang('Last Updated: December 2025')</p>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/platform-setting.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/popup.js') }}"></script>
    <script src="{{ asset('assets/admin/js/platform-setting.js') }}"></script>
@endpush
