@extends('admin.layouts.app')

@section('panel')
    <div class="doc-container">
        <div class="row gy-4">
            <div class="col-xl-3">
                <div class="doc-sidebar">
                    <h5>@lang('Table of Contents')</h5>
                    <nav class="nav flex-column">
                        <a class="nav-link active" href="#overview">@lang('Overview')</a>
                        <a class="nav-link" href="#prerequisites">@lang('Prerequisites')</a>
                        <a class="nav-link" href="#create-app">@lang('Create LinkedIn App')</a>
                        <a class="nav-link" href="#configure-app">@lang('Configure App')</a>
                        <a class="nav-link" href="#products">@lang('Add Products')</a>
                        <a class="nav-link" href="#credentials">@lang('Get Credentials')</a>
                        <a class="nav-link" href="#troubleshooting">@lang('Troubleshooting')</a>
                    </nav>
                </div>
            </div>

            <!-- Main Content -->
            <div class="col-xl-9">
                <div class="doc-content">

                    <!-- Overview Section -->
                    <section id="overview" class="doc-section">
                        <h2>@lang('Overview')</h2>
                        <p>@lang('This documentation will guide you through the process of creating and configuring a LinkedIn App to integrate LinkedIn features into your application. You\'ll learn how to create an app, configure OAuth settings, request necessary permissions, and obtain credentials for API integration.')</p>

                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Important:')</strong> @lang('LinkedIn API integration requires a LinkedIn Developer account and an approved app. Some API products require verification and approval from LinkedIn before use.')
                        </div>
                    </section>

                    <!-- Prerequisites Section -->
                    <section id="prerequisites" class="doc-section">
                        <h2>@lang('Prerequisites')</h2>

                        <p>
                            @lang('Before creating and configuring a LinkedIn App, ensure the following requirements are met. These are mandatory to avoid app creation issues, permission rejections, or verification failures.')
                        </p>

                        <div class="requirements-list">
                            <ul>
                                <li>
                                    <strong>@lang('LinkedIn Account')</strong><br>
                                    @lang('A valid LinkedIn account with a confirmed email address.')
                                </li>

                                <li>
                                    <strong>@lang('LinkedIn Company Page')</strong><br>
                                    @lang('A LinkedIn Company Page or Organization Page for creating the app. Personal accounts alone cannot create apps.')
                                </li>

                                <li>
                                    <strong>@lang('Verified Website Domain')</strong><br>
                                    @lang('A valid website with a publicly accessible domain for OAuth redirect URIs.')
                                </li>

                                <li>
                                    <strong>@lang('Privacy Policy URL (Required)')</strong><br>
                                    @lang('A publicly accessible privacy policy page explaining how user data is collected, used, and stored.')
                                </li>

                                <li>
                                    <strong>@lang('Terms of Service URL (Optional but Recommended)')</strong><br>
                                    @lang('A clear Terms of Service page describing user responsibilities and platform usage.')
                                </li>

                                <li>
                                    <strong>@lang('App Logo')</strong><br>
                                    @lang('A logo image for your application (300x300 pixels recommended).')
                                </li>

                                <li>
                                    <strong>@lang('Application Use-Case Description')</strong><br>
                                    @lang('A clear explanation of how the application uses LinkedIn data and API products. This is required during product request.')
                                </li>

                                <li>
                                    <strong>@lang('Secure Website (HTTPS)')</strong><br>
                                    @lang('The application website must use HTTPS. HTTP URLs are not accepted for OAuth redirect URIs.')
                                </li>
                            </ul>
                        </div>
                    </section>



                    <!-- Create App Section -->
                    <section id="create-app" class="doc-section">
                        <h2>@lang('Step 1: Create a LinkedIn App')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">1</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Navigate to LinkedIn Developers')</div>
                                    <p>
                                        @lang('Go to')
                                        <a href="https://www.linkedin.com/developers" target="_blank">https://www.linkedin.com/developers</a>
                                        @lang('and sign in with your LinkedIn account. Click on') <strong>@lang('"My Apps"')</strong> @lang('from the top menu.')
                                    </p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/01.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/01.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">2</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Create New App')</div>
                                    <p>
                                        @lang('Click the') <strong>@lang('"Create app"')</strong> @lang('button to start the app creation process.')
                                    </p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/02.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/02.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">3</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Fill in App Details')</div>

                                    <p>
                                        @lang('Provide the required information to complete the app creation. Follow the steps below carefully:')
                                    </p>

                                    <ul class="app-details-list">
                                        <li>
                                            <strong>@lang('App Name:')</strong>
                                            @lang('Enter a unique and descriptive name for your application.')
                                        </li>

                                        <li>
                                            <strong>@lang('LinkedIn Page:')</strong>
                                            @lang('Select the LinkedIn Company Page that will own this app.')
                                        </li>

                                        <li>
                                            <strong>@lang('Privacy Policy URL:')</strong>
                                            @lang('Provide the URL to your privacy policy.')
                                        </li>

                                        <li>
                                            <strong>@lang('App Logo:')</strong>
                                            @lang('Upload your application logo (300x300 pixels recommended).')
                                        </li>

                                        <li>
                                            <strong>@lang('Legal Agreement:')</strong>
                                            @lang('Check the box to agree to LinkedIn API Terms of Use.')
                                        </li>

                                        <li>
                                            <strong>@lang('Create App:')</strong>
                                            @lang('Click the "Create app" button to finalize app creation.')
                                        </li>
                                    </ul>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/03.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/03.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="alert-success-custom">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang('Your LinkedIn App has been created. You can now configure app settings and request products.')

                        </div>
                    </section>

                    <!-- Configure App Section -->
                    <section id="configure-app" class="doc-section">
                        <h2>@lang('Step 2: Configure App Settings')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">1</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Access Auth Settings')</div>
                                    <p>@lang('From your app dashboard, navigate to the') <strong>@lang('"Auth"')</strong> @lang('tab. Here you will configure OAuth 2.0 settings.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/04.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/04.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">2</span>
                                <div class="step-content">
                                    <div class="step-title">@lang('Add Redirect URLs')</div>
                                    <p>@lang('In the') <strong>@lang('OAuth 2.0 settings')</strong> @lang('section, find') <strong>@lang('Redirect URLs')</strong>.</p>

                                    <div class="mb-3">
                                        <p>@lang('The callback URL should be:')</p>
                                        <div class="callback-link">
                                            <code>{{ route('user.social.connect.callback', 'linkedin') }}</code>
                                            <button class="copy-btn">
                                                <i class="las la-copy"></i>
                                            </button>
                                        </div>
                                    </div>

                                    <p>@lang('Paste it in the Redirect URLs field and click') <strong>@lang('Add')</strong>.</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/05.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/05.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">3</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Verify App Settings')</div>
                                    <p>@lang('Navigate to the') <strong>@lang('Settings')</strong> @lang('tab to verify your app information.')</p>
                                    <p>@lang('Ensure all required fields are filled correctly:')</p>

                                    <ul class="app-details-list">
                                        <li>@lang('App name')</li>
                                        <li>@lang('App logo')</li>
                                        <li>@lang('Privacy policy URL')</li>
                                        <li>@lang('Associated LinkedIn Page')</li>
                                    </ul>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/06.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/06.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="alert-info-custom">
                            <strong><i class="fas fa-info-circle me-2"></i>@lang('Note:')</strong> @lang('Make sure your redirect URL uses HTTPS and matches exactly with what you configure in your application.')
                        </div>
                    </section>

                    <!-- Products Section -->
                    <section id="products" class="doc-section">
                        <h2>@lang('Step 3: Request API Products')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">1</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Navigate to Products Tab')</div>
                                    <p>@lang('Click on the') <strong>@lang('Products')</strong> @lang('tab in your app dashboard. And Add the products you need')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/07.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/07.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">2</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Request Required Products')</div>
                                    <p>@lang('LinkedIn offers different API products. Request the products that match your use case:')</p>

                                    <h4 class="mt-3">@lang('Available Products:')</h4>
                                    <div class="mt-3">
                                        <span class="permission-badge">@lang('Sign In with LinkedIn')</span>
                                        <span class="permission-badge">@lang('Share on LinkedIn')</span>
                                    </div>

                                    <p class="mt-3">@lang('For basic integration, request:') <strong>@lang('Sign In with LinkedIn')</strong> @lang('and') <strong>@lang('Share on LinkedIn')</strong>.</p>
                                    <p>@lang('Click') <strong>@lang('Request access')</strong> @lang('on each product you need.').</p>

                                    <div class="alert-info-custom">
                                        <strong><i class="fas fa-info-circle me-2"></i>@lang('Note:')</strong> @lang('Some products like "Sign In with LinkedIn" are automatically approved, while others like "Share on LinkedIn"')
                                    </div>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/08.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/08.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Product approval can take several days to weeks. You can still test with your own account while awaiting approval.')
                        </div>
                    </section>

                    <!-- Credentials Section -->
                    <section id="credentials" class="doc-section">
                        <h2>@lang('Step 4: Get Application Credentials')</h2>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">1</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Access Auth Tab')</div>
                                    <p>@lang('Navigate to the') <strong>@lang('"Auth"')</strong> @lang('tab in your app dashboard.')</p>
                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/09.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/09.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">2</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Copy Application Credentials')</div>
                                    <p>@lang('In the') <strong>@lang('Application credentials')</strong> @lang('section, you\'ll find:')</p>

                                    <ul class="app-details-list">
                                        <li>
                                            <strong>@lang('Client ID:')</strong>
                                            @lang('Your application\'s public identifier')
                                        </li>
                                        <li>
                                            <strong>@lang('Client Secret:')</strong>
                                            @lang('Your application\'s secret key (click "Show" to reveal)')
                                        </li>
                                    </ul>

                                    <p>@lang('Copy both the Client ID and Client Secret.')</p>

                                    <div class="alert-warning-custom">
                                        <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Keep your Client Secret secure. Never share it publicly or commit it to version control. Anyone with your Client Secret can make API calls on behalf of your application.')
                                    </div>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/10.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/10.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">3</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Configure in Your Application')</div>
                                    <p>@lang('Navigate to your Platform Settings section and enter the Client ID and Client Secret in the respective LinkedIn configuration fields.')</p>
                                    <p>@lang('Save the configuration to complete the integration.')</p>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/11.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/11.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="step-card">
                            <div class="d-flex align-items-start  step-card__wrapper">
                                <span class="step-number">4</span>
                               <div class="step-content">
                                    <div class="step-title">@lang('Review OAuth Scopes')</div>
                                    <p>@lang('In the Auth tab, scroll down to') <strong>@lang('OAuth 2.0 scopes')</strong> @lang('section.')</p>
                                    <p>@lang('Verify that the scopes you need are available based on the products you\'ve requested:')</p>

                                    <div class="mt-3">
                                        <span class="permission-badge">openid</span>
                                        <span class="permission-badge">profile</span>
                                        <span class="permission-badge">email</span>
                                        <span class="permission-badge">w_member_social</span>
                                        <span class="permission-badge">r_events</span>
                                        <span class="permission-badge">rw_events</span>
                                    </div>

                                    <div class="screenshot-wrapper">
                                        <a href="{{ asset('assets/admin/images/documentation/linkedin/12.png') }}" class="image-link">
                                            <img class="fit-image lazy" data-src="{{ asset('assets/admin/images/documentation/linkedin/12.png') }}" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==" alt="@lang('Screenshot')">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert-success-custom">
                            <strong>
                                <i class="fas fa-check-circle me-2"></i>@lang('Success!')
                            </strong>
                            @lang('Your LinkedIn App integration is now configured. You can start testing with your account.')
                        </div>
                    </section>

                    <!-- Troubleshooting Section -->
                    <section id="troubleshooting" class="doc-section">
                        <h2>@lang('Troubleshooting')</h2>

                        <h3>@lang('Common Issues and Solutions')</h3>

                        <div class="step-card">
                            <div class="step-title">@lang('Redirect URI Mismatch Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('redirect_uri does not match registered redirect URIs')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Ensure your redirect URI in the application exactly matches the one configured in LinkedIn Developer Portal. Check for:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('Exact URL match (case-sensitive)')</li>
                                <li>@lang('Trailing slashes')</li>
                                <li>@lang('HTTP vs HTTPS')</li>
                                <li>@lang('Query parameters or fragments')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Access Denied Error')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Not enough permissions to access resource')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('This usually means:')
                            </p>
                            <ul class="app-details-list">
                                <li>@lang('The required API product is not added to your app')</li>
                                <li>@lang('Your product request is still pending approval')</li>
                                <li>@lang('The scope you\'re requesting is not available for your app')</li>
                            </ul>
                            <p>@lang('Check the Products tab to verify which products are approved for your app.')</p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Invalid Client ID or Secret')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('invalid_client or unauthorized_client error')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('Verify that:'):</p>
                            <ul class="app-details-list">
                                <li>@lang('You\'ve copied the correct Client ID and Client Secret')</li>
                                <li>@lang('There are no extra spaces before or after the credentials')</li>
                                <li>@lang('You\'re using credentials from the correct app')</li>
                                <li>@lang('The app is not in a restricted or suspended state')</li>
                            </ul>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Cannot Create App')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Unable to create LinkedIn app')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('LinkedIn apps must be associated with a LinkedIn Company Page. You cannot create an app with just a personal account. Create or get admin access to a LinkedIn Company Page first.')
                            </p>
                        </div>

                        <div class="step-card">
                            <div class="step-title">@lang('Expired Access Token')</div>
                            <p><strong>@lang('Problem'):</strong> @lang('Access token expired or invalid')</p>
                            <p><strong>@lang('Solution'):</strong> @lang('LinkedIn access tokens expire after 60 days. Implement token refresh logic in your application to automatically renew tokens before they expire.')
                            </p>
                        </div>

                        <div class="alert-warning-custom">
                            <strong><i class="fas fa-exclamation-triangle me-2"></i>@lang('Important:')</strong> @lang('Without approved API products, your integration will have limited functionality. You can test with your own LinkedIn account while product requests are pending, but end users won\'t be able to use the features until approval is granted.')
                        </div>

                        <h3>@lang('Useful Resources')</h3>
                        <div class="requirements-list">
                            <ul class="app-details-list">
                                <li><a href="https://docs.microsoft.com/en-us/linkedin/" target="_blank">@lang('LinkedIn API Documentation')</a></li>
                                <li><a href="https://www.linkedin.com/developers/apps" target="_blank">@lang('LinkedIn Developer Portal')</a></li>
                                <li><a href="https://docs.microsoft.com/en-us/linkedin/shared/authentication/authentication" target="_blank">@lang('OAuth 2.0 Authentication Guide')</a></li>
                                <li><a href="https://docs.microsoft.com/en-us/linkedin/shared/api-guide/concepts/error-handling" target="_blank">@lang('Error Handling Reference')</a></li>
                                <li><a href="https://docs.microsoft.com/en-us/linkedin/consumer/integrations/self-serve/share-on-linkedin" target="_blank">@lang('Share on LinkedIn Guide')</a></li>
                            </ul>
                        </div>
                    </section>

                    <div class="text-center mt-5 pt-4 border-top">
                        <p class="text-muted">@lang('Last Updated: December 2025')</p>
                    </div>

                </div>
            </div>
        </div>

    </div>
@endsection
@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/popup.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/platform-setting.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/popup.js') }}"></script>
    <script src="{{ asset('assets/admin/js/platform-setting.js') }}"></script>
@endpush
