@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Total Channel')</th>
                                    <th>@lang('Total Post')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($plans as $plan)
                                    <tr>
                                        <td>{{ __($plan->name) }}</td>
                                        <td>
                                            <span>@lang('Monthly') : {{ getAmount($plan->monthly_total_channel) }}</span><br>
                                            <span>@lang('Yearly') : {{ getAmount($plan->yearly_total_channel) }}</span>
                                        </td>
                                        <td>
                                            <span>@lang('Monthly') : {{ getAmount($plan->monthly_total_post_schedule) }}</span><br>
                                            <span>@lang('Yearly') : {{ getAmount($plan->yearly_total_post_schedule) }}</span>
                                        </td>
                                        <td>
                                            <span>@lang('Monthly') : {{ showAmount($plan->monthly_price) }}</span><br>
                                            <span>@lang('Yearly') : {{ showAmount($plan->yearly_price) }}</span>
                                        </td>
                                        <td>
                                            @php
                                                echo $plan->statusBadge;
                                            @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.plans.edit', $plan->id) }}" class="btn btn-outline--primary">
                                                    <i class="las la-pen"></i>
                                                    @lang('Edit')
                                                </a>
                                                @if (!$plan->status)
                                                    <button class="btn btn-outline--success confirmationBtn" data-action="{{ route('admin.plans.status', $plan->id) }}" data-question="@lang('Are you sure to enable this plan?')">
                                                        <i class="la la-eye"></i>@lang('Enable')
                                                    </button>
                                                @else
                                                    <button
                                                            class="btn btn-outline--danger  confirmationBtn"
                                                            data-action="{{ route('admin.plans.status', $plan->id) }}"
                                                            data-question="@lang('Are you sure to disable this plan?')">
                                                        <i class="la la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($plans->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($plans) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection


@push('breadcrumb-plugins')
    <x-search-form placeholder="Search by title" />
    <a href="{{ route('admin.plans.create') }}" data-plan="" class="btn btn-outline--primary">
        <i class="las la-plus"></i>
        @lang('Add New')
    </a>
@endpush
