@extends('admin.layouts.app')
@section('panel')
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card bg-card-style">
                <div class="card-body">
                    <form action="{{ route('admin.plans.store', $plan?->id ?? 0) }}" method="POST">
                        @csrf
                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Name')</p>
                                <p class="note">@lang('The name of the pricing plan (e.g., Basic, Pro, Premium).')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <input class="form-control" type="text" name="name" value="{{ old('name', $plan?->name ?? '') }}" required>
                            </div>
                        </div>

                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Monthly Maximum Channel Connection')</p>
                                <p class="note">@lang('The maximum number of channels you can connect with this plan in monthly.')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <input class="form-control" type="number" name="monthly_total_channel" value="{{ old('monthly_total_channel', $plan?->monthly_total_channel ?? '') }}" required>
                            </div>
                        </div>
                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Yearly Maximum Channel Connection')</p>
                                <p class="note">@lang('The maximum number of channels you can connect with this plan in yearly.')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <input class="form-control" type="number" name="yearly_total_channel" value="{{ old('yearly_total_channel', $plan?->yearly_total_channel ?? '') }}" required>
                            </div>
                        </div>

                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Monthly Total Post Schedule')</p>
                                <p class="note">@lang('The total number of posts you can schedule with this plan in monthly.')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <input class="form-control" type="number" name="monthly_total_post_schedule" value="{{ old('monthly_total_post_schedule', $plan?->monthly_total_post_schedule ?? '') }}" required>
                            </div>
                        </div>

                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Yearly Total Post Schedule')</p>
                                <p class="note">@lang('The total number of posts you can schedule with this plan in yearly.')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <input class="form-control" type="number" name="yearly_total_post_schedule" value="{{ old('yearly_total_post_schedule', $plan?->yearly_total_post_schedule ?? '') }}" required>
                            </div>
                        </div>

                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Monthly Price')</p>
                                <p class="note">@lang('The subscription cost charged on a monthly basis.')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <div class="input-group">
                                    <input class="form-control" type="number" step="any" name="monthly_price" value="{{ old('monthly_price', getAmount($plan?->monthly_price ?? 0)) }}" required>
                                    <span class="input-group-text">{{ gs('cur_text') }}</span>
                                </div>
                            </div>
                        </div>

                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Yearly Price')</p>
                                <p class="note">@lang('The subscription cost charged annually (often discounted from monthly pricing).')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <div class="input-group">
                                    <input class="form-control" type="number" step="any" name="yearly_price" value="{{ old('yearly_price', getAmount($plan?->yearly_price ?? 0)) }}" required>
                                    <span class="input-group-text">{{ gs('cur_text') }}</span>
                                </div>
                            </div>
                        </div>

                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Allow AI Assistant')</p>
                                <p class="note">@lang('Specifies whether this plan includes access to the AI Assistant.')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="35" data-on="@lang('Yes')" data-off="@lang('No')" name="ai_assistant" @checked($plan?->ai_assistant ?? '')>
                            </div>
                        </div>
                        <div class="field-wrapper">
                            <div class="field-wrapper-label">
                                <p class="title">@lang('Feature')</p>
                                <p class="note">@lang('Highlights the key tools and functionalities included in this plan.')</p>
                            </div>
                            <div class="field-wrapper-view">
                                <div class="input-group form-group">
                                    <input class="form-control" type="text" name="features[]" value="{{ $plan->features[0] ?? null }}" required>
                                    <button class="input-group-text text--primary addMoreFeatureBtn" type="button"> <i class="la la-plus"></i> @lang('Add More')</button>
                                </div>

                                <div class="moreFeatures">
                                    @foreach ($plan->features ?? [] as $feature)
                                        @continue($loop->first)
                                        <div class="form-group d-flex justify-content-between">
                                            <input type="text" name="features[]" class="form-control"
                                                   value="{{ $feature }}" required>
                                            <button type="button" class="btn btn-sm btn-danger removeFeatureBtn ms-2">
                                                <i class="las la-trash-alt ps-1"></i>
                                            </button>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>



                        <button class="btn btn--primary w-100 h-45" type="submit">@lang('Submit')</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.plans.index') }}" />
@endpush

@push('style')
    <style>
        .card.bg-card-style .card-heading {
            padding: 12px 16px;
            background-color: rgb(0, 0, 0, 5%);
            border-radius: 8px;
            margin-bottom: 24px
        }

        .card.bg-card-style .card-body {}

        .field-wrapper {
            display: flex;
            align-items: center;
            gap: 16px 24px;
            flex-wrap: wrap;
        }

        .field-wrapper:not(:last-child) {
            margin-bottom: 24px;
        }

        .field-wrapper-label {
            width: 320px;
        }

        .field-wrapper-label .title {
            color: black;
            font-weight: 600;
        }

        .field-wrapper-label .note {
            font-size: 0.75rem;
        }

        .field-wrapper-view {
            flex: 1;
            max-width: 700px;
        }

        .field-wrapper .image-upload-wrapper {
            height: 150px;
            position: relative;
            width: 160px;
        }

        @media (max-width: 767px) {
            .field-wrapper {
                flex-direction: column;
                align-items: flex-start;
            }

            .field-wrapper-label {
                width: 100%;
            }
        }
    </style>
@endpush
@push('script')
    <script>
        "use strict";

        $('.addMoreFeatureBtn').on('click', function() {

            let html = `<div class="input-group form-group">
                            <input class="form-control" type="text" name="features[]" required>
                            <button class="input-group-text text--danger removeFeatureBtn" type="button"> <i class="las la-times"></i> @lang('Remove')</button>
                        </div>`;
            $('.moreFeatures').append(html);
        });

        $(document).on('click', '.removeFeatureBtn', function() {
            $(this).closest('.form-group').remove();
        });
    </script>
@endpush
