@extends('admin.layouts.app')
@section('panel')
    <div class="row justify-content-center gy-4">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.openai.setup.update') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-xl-6 col-sm-6">
                                <div class="form-group">
                                    <label> @lang('Secret Key')</label>
                                    <input class="form-control" name="secret_key" type="text" placeholder="@lang('Secret Key')" value="{{ $openaiKey ?? '-----' }}" required>
                                </div>
                            </div>
                            <div class="col-xl-6 col-sm-6">
                                <div class="form-group">
                                    <label> @lang('Select AI Model')</label>
                                    <select class="select2 form-control" name="ai_model">
                                        @foreach ($models as $item)
                                            <option value="{{ $item->id }}" @selected(gs('ai_model') == $item->id)>{{ $item->name }}
                                                ({{ $item->label }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-0 text-end">
                            <button class="btn btn--primary ms-auto w-100 h-45" type="submit">@lang('Save')</button>
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>

    {{-- HELP METHOD MODAL --}}
    <div id="helpModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('How to configure OpenAI API credentials?')</h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-group credentials__list credentials__list__two">

                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('breadcrumb-plugins')
    <button type="button" class="btn btn-sm btn-outline--primary me-2 helpBtn" data-bs-original-title="Help"><i class="las la-info-circle"></i>
        @lang('Help') </button>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $('.copyInput').on('click', function(e) {
                var copybtn = $(this);
                var input = copybtn.closest('.input-group').find('input');
                if (input && input.select) {
                    input.select();
                    try {
                        document.execCommand('SelectAll')
                        document.execCommand('Copy', false, null);
                        input.blur();
                        notify('success', `Copied: ${copybtn.closest('.input-group').find('input').val()}`);
                    } catch (err) {
                        console.log('err');
                    }
                }
            });

            $(document).on('click', '.helpBtn', function() {
                var modal = $('#helpModal');
                var html = `
                            <li class="list-group-item">
                                <span>@lang('Step 1: Go to Official Website')</span>
                                <span>@lang('Go to') <a href="https://platform.openai.com/" target="_blank">@lang('Open AI Official Website')</a></span>
                            </li>
                            <li class="list-group-item">
                                <span>@lang('Step 2: Create/Open an OpenAI Account')</span>
                                <span> 
                                     1. @lang('If you already have an OpenAI account, click “Log in”') </br>
                                     2. @lang('Or ') <a href="https://platform.openai.com/signup" target="_blank">@lang('Create OpenAI Account')</a></br>
                                </span>
                            </li>
                            <li class="list-group-item">
                                <span>@lang('Step 3: Add Billing Information (Required for API Access)')</span>
                                <span> 
                                     1. <a href="https://platform.openai.com/account" target="_blank">@lang('Account Management')</a></br>
                                     2. <a href="https://platform.openai.com/account/billing" target="_blank">@lang('Manage Billing Details')</a></br>
                                     3. @lang('Add credit/debit card under') <a href="https://platform.openai.com/account/billing/payment-methods" target="_blank">@lang('Payment methods')</a></br></br>

                                     @lang('Note: You must add a valid card to use GPT-4 and related APIs.')
                                </span>
                            </li>
                            <li class="list-group-item">
                                <span>@lang('Step 4: Generate API Key')</span>
                                <span> 
                                     1. @lang('Go to') <a href="https://platform.openai.com/api-keys" target="_blank">@lang('API Keys page')</a></br>
                                     2. @lang('Click + Create new secret key') </br>
                                     3. @lang('Optionally name your key') </br>
                                </span>
                            </li>
                            <li class="list-group-item">
                                <span>@lang('Step 5: Copy and Save the Key')</span>
                                <span>
                                    1. @lang('The key will be shown only once') </br>
                                    2. @lang('Copy and store securely') </br>
                                </span>
                            </li>
                            <li class="list-group-item">
                                <span>@lang('Step 6: Submit Your Secret Key to Our Platform'):</span>
                                <span>@lang('Save your generated secret key.')</a></span>
                            </li>
                        `;
                $('.list-group').html(html);
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
