@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <form action="{{ route('admin.coupon.store', $coupon->id ?? '') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="name" class="required">@lang('Coupon Name')</label>
                                    <input type="text" class="form-control" name="name" value="{{ old('name', $coupon->name ?? '') }}" placeholder="@lang('Type Here')..." required id="name">
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="form-group">
                                    <label for="code" class="required">@lang('Coupon Code')</label>
                                    <input type="text" class="form-control" name="code" value="{{ old('code', $coupon->code ?? '') }}" placeholder="@lang('Type Here')..." required id="code">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="discount_type" class="required">@lang('Discount Type')</label>
                                    <div class="position-relative"><select class="form-control select2 select2-hidden-accessible" data-minimum-results-for-search="-1" name="discount_type" required="" id="discount_type" data-select2-id="select2-data-discount_type" tabindex="-1" aria-hidden="true">
                                            <option value="" data-select2-id="select2-data-2-uw6o" selected disabled>@lang('Select Discount Type')</option>
                                            <option value="{{ Status::DISCOUNT_FIXED }}" @selected(old('discount_type', $coupon->discount_type ?? '') == Status::DISCOUNT_FIXED)>
                                                @lang('Fixed') </option>
                                            <option value="{{ Status::DISCOUNT_PERCENT }}" @selected(old('discount_type', $coupon->discount_type ?? '') == Status::DISCOUNT_PERCENT)>
                                                @lang('Percentage') </option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount" class="required">@lang('Amount')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="amount" value="{{ old('amount', $coupon->amount ?? '') }}" required id="amount">
                                        <span class="input-group-text" id="discount_type_text">
                                            {{ gs('cur_text') }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="start_date" class="required">@lang('Start Date')</label>
                                    <input type="text" name="started_at" class="form-control" data-language="en" data-format="yyyy-mm-dd" data-position="bottom left" value="{{ old('started_date', $coupon->started_at ?? '') }}" placeholder="Select Date" autocomplete="off" required="" id="start_date">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="end_date" class="required">@lang('End Date')</label>
                                    <input type="text" name="expired_at" class="form-control" data-language="en" data-format="yyyy-mm-dd" data-position="bottom left" value="{{ old('expired_at', $coupon->expired_at ?? '') }}" placeholder="Select Date" autocomplete="off" required="" id="end_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card my-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">@lang('Usage Restrictions')</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="minimum_spend" class="required">@lang('Minimum Spend')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="minimum_spend" value="{{ old('minium_spend', $coupon->minimum_spend ?? '') }}" placeholder="@lang('Type Here')..." min="0" required="" id="minimum_spend">
                                        <span class="input-group-text">{{ gs('cur_text') }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="usage_limit_per_coupon">@lang('Usage Limit Per Coupon')</label>
                                    <input type="number" class="form-control" name="usage_limit_per_coupon" value="{{ old('usage_limit_per_coupon', $coupon->usage_limit_per_coupon ?? '') }}" placeholder="@lang('Type Here')..." id="usage_limit_per_coupon">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="usage_limit_per_customer">@lang('Usage Limit Per Customer')</label>
                                    <input type="number" class="form-control" name="usage_limit_per_customer" value="{{ old('usage_limit_per_customer', $coupon->usage_limit_per_customer ?? '') }}" placeholder="@lang('Type Here')..." id="usage_limit_per_customer">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection


@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.coupon.index') }}"></x-back>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/daterangepicker.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/admin/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/daterangepicker.min.js') }}"></script>
@endpush




@push('script')
    <script src="{{ asset('assets/admin/js/highlighter22.js') }}"></script>
    <script>
        'use strict';
        (function($) {
            const dateInputs = $('[name=expired_at], [name=started_at]');

            dateInputs.daterangepicker({
                timePicker: true,
                singleDatePicker: true,
                locale: {
                    format: 'YYYY-MM-DD hh:mm A'
                },
                applyButtonClasses: 'btn--primary',
                autoUpdateInput: false,
                minDate: moment().startOf('day'),
                parentEl: '#couponModal'
            });

            dateInputs.on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD hh:mm A'));
            });
        })(jQuery);
    </script>
@endpush
