<?php

namespace App\Models;

use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SocialAccount extends Model {
    use HasFactory, GlobalStatus;

    protected $casts = [
        'extra_data' => 'object',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function platform() {
        return $this->belongsTo(Platform::class);
    }
}
