<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Post extends Model {
    protected $casts = [
        'account_ids' => 'array',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function medias() {
        return $this->hasMany(PostMedia::class);
    }

    public function scopeSchedule($query) {
        return $query->where('status', Status::SCHEDULE);
    }
    public function scopeDraft($query) {
        return $query->where('status', Status::DRAFT);
    }
    public function scopePublished($query) {
        return $query->where('status', Status::PUBLISH);
    }

    public function getAccountsAttribute() {
        if (!$this->account_ids || !is_array($this->account_ids)) {
            return collect();
        }

        return SocialAccount::whereIn('id', $this->account_ids)->get();
    }

    public function accounts() {
        return SocialAccount::whereIn('id', $this->account_ids)->get();
    }
    
    public function statusBadge(): Attribute {
        return new Attribute(function () {
            $html = '';
            if ($this->status == Status::SCHEDULE) {
                $html = '<span class="badge badge--info">' . trans('Scheduled') . '</span>';
            } else if ($this->status == Status::PUBLISH) {
                $html = '<span><span class="badge badge--base">' . trans('Published') . '</span>';
            } else {
                $html = '<span class="badge badge--warning">' . trans('Draft') . '</span>';
            }
            return $html;
        });
    }
}
