<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    use GlobalStatus;

    public function scopeActive($query){
        return $query->where('status', Status::ENABLE)->where('expired_at', '>=', now()->format('Y-m-d H:i:s'))->where('started_at', '<=', now()->format('Y-m-d H:i:s'));
    }

    public function discountTypeBadge()
    {
        if ($this->discount_type == Status::DISCOUNT_FIXED) {
            return '<span class="badge badge--primary">' . trans('Fixed') . '</span>';
        } else {
            return '<span class="badge badge--dark">' . trans('Percentage') . '</span>';
        }
    }

    public function discountAmount($subtotal){
        if ($this->discount_type == Status::DISCOUNT_FIXED) {
            return $subtotal - $this->amount;
        } else {
            return $subtotal - ($this->amount / 100) * $subtotal;
        }
    }
}
