<?php

namespace App\Http\Controllers\User;

use App\Models\Post;
use App\Constants\Status;
use Illuminate\Http\Request;
use App\Models\SocialAccount;
use App\Http\Controllers\Controller;

class ScheduleController extends Controller
{

    public function index()
    {
        $pageTitle = 'Schedules';

        $schedules = Post::where('user_id', auth()->id())
            ->where('status', Status::SCHEDULE)
            ->get();

        $allAccountIds = $schedules->pluck('account_ids')->flatten()->unique();

        $accounts = SocialAccount::whereIn('id', $allAccountIds)
            ->with('platform')
            ->get()
            ->keyBy('id');

        $events = $schedules->map(function ($schedule) use ($accounts) {
            $platforms = collect($schedule->account_ids)->map(function ($id) use ($accounts) {
                $account = $accounts->get($id);
                return [
                    'image' => $account?->profile_image
                        ?? getImage('assets/images/default.png'),
                ];
            });

            return [
                'id'    => $schedule->id,
                'title' => strLimit($schedule->content, 30) ?? '',
                'start' => $schedule->schedule_start_date . 'T' . $schedule->schedule_time,
                'end'   => $schedule->schedule_end_date
                    ? $schedule->schedule_end_date . 'T' . $schedule->schedule_time
                    : null,
                'platforms' => $platforms->toArray(),
            ];
        });

        return view('Template::user.schedule.index', compact('pageTitle', 'schedules', 'events'));
    }
}
