<?php

namespace App\Http\Controllers\User;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Plan;

class MembershipController extends Controller {
    public function membership() {
        $pageTitle = "Upgrade Your Plan";
        $user      = auth()->user();
        $plans     = Plan::active()->paginate(getPaginate());
        return view('Template::user.member', compact('pageTitle', 'plans', 'user'));
    }

    public function freeTrial() {
        $user = auth()->user();

        if (gs('free_trial_status') != Status::YES) {
            $notify[] = ['error', 'Free Trial is currently not available'];
            return back()->withNotify($notify);
        }

        if ($user->free_plan_used == Status::YES) {
            $notify[] = ['error', 'You have already used your free trial'];
            return back()->withNotify($notify);
        }

        $user->free_plan_used = Status::YES;
        $user->plan_id        = 0;
        $user->started_at     = now();
        $user->expired_at     = now()->addDays(gs('free_trial_days'));
        $user->total_channel  = gs('channel_count');
        $user->total_schedule = gs('schedule_count');
        $user->save();

        $notify[] = ['success', 'You have successfully activated your free trial'];
        return back()->withNotify($notify);
    }
}
