<?php

namespace App\Http\Controllers\Admin;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Lib\RequiredConfig;
use App\Models\Plan;
use Illuminate\Http\Request;

class PlanController extends Controller {
    public function index() {
        $pageTitle = "Plans";
        $plans     = Plan::searchable(['name'])->orderBy('id', 'desc')->paginate(getPaginate());
        return view('admin.plan.index', compact('pageTitle', 'plans'));
    }

    public function create() {
        $pageTitle = "Add New Plan";
        return view('admin.plan.form', compact('pageTitle'));
    }

    public function edit($id) {
        $pageTitle = "Edit Plan";
        $plan      = Plan::findOrFail($id);
        return view('admin.plan.form', compact('pageTitle', 'plan'));
    }

    public function store(Request $request, $id = NULL) {
        $request->validate([
            'name'                        => 'required|string|max:255',
            'monthly_price'               => 'required|numeric|gt:0',
            'yearly_price'                => 'required|numeric|gt:monthly_price',
            'monthly_total_channel'       => 'required|numeric|gt:0',
            'yearly_total_channel'        => 'required|numeric|gt:monthly_total_channel',
            'monthly_total_post_schedule' => 'required|numeric|gt:0',
            'yearly_total_post_schedule'  => 'required|numeric|gt:monthly_total_post_schedule',
            'features'                    => 'required|array',
            'features.*'                  => 'required|string',
        ]);

        if ($id) {
            $plan     = Plan::findOrFail($id);
            $notify[] = ['success', 'Plan updated successfully'];
        } else {
            $plan     = new Plan();
            $notify[] = ['success', 'Plan saved successfully'];
        }

        $plan->name                        = $request->name;
        $plan->monthly_price               = $request->monthly_price;
        $plan->yearly_price                = $request->yearly_price;
        $plan->monthly_total_channel       = $request->monthly_total_channel;
        $plan->yearly_total_channel        = $request->yearly_total_channel;
        $plan->monthly_total_post_schedule = $request->monthly_total_post_schedule;
        $plan->yearly_total_post_schedule  = $request->yearly_total_post_schedule;
        $plan->features                    = $request->features;
        $plan->ai_assistant                = $request->has('ai_assistant') ? Status::ENABLE : Status::DISABLE;
        $plan->save();

        RequiredConfig::configured('plan');
        return back()->withNotify($notify);
    }

    public function status($id) {
        return Plan::changeStatus($id);
    }
}
