"use strict";
(function ($) {
  $(".doc-sidebar .nav-link").on("click", function (e) {
    e.preventDefault();

    $(".doc-sidebar .nav-link").removeClass("active");

    $(this).addClass("active");

    var targetId = $(this).attr("href");
    var targetSection = $(targetId);

    if (targetSection.length) {
      $("html, body").animate(
        {
          scrollTop: targetSection.offset().top - 20,
        },
        600
      );
    }
  });

  $(window).on("scroll", function () {
    var current = "";
    var scrollPos = $(window).scrollTop();

    $(".doc-section").each(function () {
      var sectionTop = $(this).offset().top;
      var sectionId = $(this).attr("id");

      if (scrollPos >= sectionTop - 100) {
        current = sectionId;
      }
    });

    $(".doc-sidebar .nav-link").removeClass("active");
    $('.doc-sidebar .nav-link[href="#' + current + '"]').addClass("active");
  });

  $(".image-link").magnificPopup({
    type: "image",
    gallery: {
      enabled: true,
    },
  });

  $(".copy-btn").on("click", function () {
    const btn = $(this);
    const text = btn.closest(".callback-link").find("code").text();

    navigator.clipboard
      .writeText(text)
      .then(() => {
        btn.addClass("copied");
        btn.html('<i class="las la-check"></i>');

        setTimeout(() => {
          btn.removeClass("copied");
          btn.html('<i class="las la-copy"></i>');
        }, 2000);
      })
      .catch(() => {
        notify("error", "Failed to copy");
      });
  });

  function initLazy() {
    const lazyImages = document.querySelectorAll("img.lazy[data-src]");
    const observer = new IntersectionObserver((entries, obs) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          const img = entry.target;
          img.src = img.dataset.src;
          img.classList.remove("lazy");
          img.removeAttribute("data-src");
          obs.unobserve(img);
        }
      });
    });

    lazyImages.forEach((img) => observer.observe(img));
  }
  initLazy();
})(jQuery);
